// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateInferenceExperimentRequest private constructor(builder: Builder) {
    /**
     * The Amazon S3 location and configuration for storing inference request and response data.
     *
     *  This is an optional parameter that you can use for data capture. For more information, see [Capture data](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html).
     */
    public val dataStorageConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig? = builder.dataStorageConfig
    /**
     * A description for the inference experiment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the Amazon SageMaker endpoint on which you want to run the inference experiment.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. The `KmsKey` can be any of the following formats:
     * + KMS key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS key`"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + KMS key Alias`"alias/ExampleAlias"`
     * + Amazon Resource Name (ARN) of a KMS key Alias`"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
     *
     *  If you use a KMS key ID or an alias of your KMS key, the Amazon SageMaker execution role must include permissions to call `kms:Encrypt`. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. Amazon SageMaker uses server-side encryption with KMS managed keys for `OutputDataConfig`. If you use a bucket policy with an `s3:PutObject` permission that only allows objects with server-side encryption, set the condition key of `s3:x-amz-server-side-encryption` to `"aws:kms"`. For more information, see [KMS managed Encryption Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Developer Guide.*
     *
     *  The KMS key policy must grant permission to the IAM role that you specify in your `CreateEndpoint` and `UpdateEndpoint` requests. For more information, see [Using Key Policies in Amazon Web Services KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Amazon Web Services Key Management Service Developer Guide*.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * An array of `ModelVariantConfig` objects. There is one for each variant in the inference experiment. Each `ModelVariantConfig` object in the array describes the infrastructure configuration for the corresponding variant.
     */
    public val modelVariants: List<ModelVariantConfig>? = builder.modelVariants
    /**
     * The name for the inference experiment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The duration for which you want the inference experiment to run. If you don't specify this field, the experiment automatically starts immediately upon creation and concludes after 7 days.
     */
    public val schedule: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule? = builder.schedule
    /**
     * The configuration of `ShadowMode` inference experiment type. Use this field to specify a production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant also specify the percentage of requests that Amazon SageMaker replicates.
     */
    public val shadowModeConfig: aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig? = builder.shadowModeConfig
    /**
     * Array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging your Amazon Web Services Resources](https://docs.aws.amazon.com/ARG/latest/userguide/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of the inference experiment that you want to run. The following types of experiments are possible:
     * + `ShadowMode`: You can use this type to validate a shadow variant. For more information, see [Shadow tests](https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html).
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateInferenceExperimentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInferenceExperimentRequest(")
        append("dataStorageConfig=$dataStorageConfig,")
        append("description=$description,")
        append("endpointName=$endpointName,")
        append("kmsKey=$kmsKey,")
        append("modelVariants=$modelVariants,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("shadowModeConfig=$shadowModeConfig,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataStorageConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (modelVariants?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (shadowModeConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInferenceExperimentRequest

        if (dataStorageConfig != other.dataStorageConfig) return false
        if (description != other.description) return false
        if (endpointName != other.endpointName) return false
        if (kmsKey != other.kmsKey) return false
        if (modelVariants != other.modelVariants) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (shadowModeConfig != other.shadowModeConfig) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateInferenceExperimentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 location and configuration for storing inference request and response data.
         *
         *  This is an optional parameter that you can use for data capture. For more information, see [Capture data](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html).
         */
        public var dataStorageConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig? = null
        /**
         * A description for the inference experiment.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the Amazon SageMaker endpoint on which you want to run the inference experiment.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. The `KmsKey` can be any of the following formats:
         * + KMS key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS key`"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + KMS key Alias`"alias/ExampleAlias"`
         * + Amazon Resource Name (ARN) of a KMS key Alias`"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
         *
         *  If you use a KMS key ID or an alias of your KMS key, the Amazon SageMaker execution role must include permissions to call `kms:Encrypt`. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. Amazon SageMaker uses server-side encryption with KMS managed keys for `OutputDataConfig`. If you use a bucket policy with an `s3:PutObject` permission that only allows objects with server-side encryption, set the condition key of `s3:x-amz-server-side-encryption` to `"aws:kms"`. For more information, see [KMS managed Encryption Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Developer Guide.*
         *
         *  The KMS key policy must grant permission to the IAM role that you specify in your `CreateEndpoint` and `UpdateEndpoint` requests. For more information, see [Using Key Policies in Amazon Web Services KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Amazon Web Services Key Management Service Developer Guide*.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * An array of `ModelVariantConfig` objects. There is one for each variant in the inference experiment. Each `ModelVariantConfig` object in the array describes the infrastructure configuration for the corresponding variant.
         */
        public var modelVariants: List<ModelVariantConfig>? = null
        /**
         * The name for the inference experiment.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The duration for which you want the inference experiment to run. If you don't specify this field, the experiment automatically starts immediately upon creation and concludes after 7 days.
         */
        public var schedule: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule? = null
        /**
         * The configuration of `ShadowMode` inference experiment type. Use this field to specify a production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant also specify the percentage of requests that Amazon SageMaker replicates.
         */
        public var shadowModeConfig: aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig? = null
        /**
         * Array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging your Amazon Web Services Resources](https://docs.aws.amazon.com/ARG/latest/userguide/tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The type of the inference experiment that you want to run. The following types of experiments are possible:
         * + `ShadowMode`: You can use this type to validate a shadow variant. For more information, see [Shadow tests](https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html).
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateInferenceExperimentRequest) : this() {
            this.dataStorageConfig = x.dataStorageConfig
            this.description = x.description
            this.endpointName = x.endpointName
            this.kmsKey = x.kmsKey
            this.modelVariants = x.modelVariants
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.shadowModeConfig = x.shadowModeConfig
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateInferenceExperimentRequest = CreateInferenceExperimentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig] inside the given [block]
         */
        public fun dataStorageConfig(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig.Builder.() -> kotlin.Unit) {
            this.dataStorageConfig = aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig] inside the given [block]
         */
        public fun shadowModeConfig(block: aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig.Builder.() -> kotlin.Unit) {
            this.shadowModeConfig = aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
