// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateActionRequest private constructor(builder: Builder) {
    /**
     * The name of the action. Must be unique to your account in an Amazon Web Services Region.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * The action type.
     */
    public val actionType: kotlin.String? = builder.actionType
    /**
     * The description of the action.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    public val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * A list of properties to add to the action.
     */
    public val properties: Map<String, String>? = builder.properties
    /**
     * The source type, ID, and URI.
     */
    public val source: aws.sdk.kotlin.services.sagemaker.model.ActionSource? = builder.source
    /**
     * The status of the action.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.ActionStatus? = builder.status
    /**
     * A list of tags to apply to the action.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateActionRequest(")
        append("actionName=$actionName,")
        append("actionType=$actionType,")
        append("description=$description,")
        append("metadataProperties=$metadataProperties,")
        append("properties=$properties,")
        append("source=$source,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionName?.hashCode() ?: 0
        result = 31 * result + (actionType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateActionRequest

        if (actionName != other.actionName) return false
        if (actionType != other.actionType) return false
        if (description != other.description) return false
        if (metadataProperties != other.metadataProperties) return false
        if (properties != other.properties) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateActionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the action. Must be unique to your account in an Amazon Web Services Region.
         */
        public var actionName: kotlin.String? = null
        /**
         * The action type.
         */
        public var actionType: kotlin.String? = null
        /**
         * The description of the action.
         */
        public var description: kotlin.String? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        public var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * A list of properties to add to the action.
         */
        public var properties: Map<String, String>? = null
        /**
         * The source type, ID, and URI.
         */
        public var source: aws.sdk.kotlin.services.sagemaker.model.ActionSource? = null
        /**
         * The status of the action.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.ActionStatus? = null
        /**
         * A list of tags to apply to the action.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateActionRequest) : this() {
            this.actionName = x.actionName
            this.actionType = x.actionType
            this.description = x.description
            this.metadataProperties = x.metadataProperties
            this.properties = x.properties
            this.source = x.source
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateActionRequest = CreateActionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        public fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ActionSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.sagemaker.model.ActionSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.sagemaker.model.ActionSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
