// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The specifications of an instance group that you need to define.
 */
public class ClusterInstanceGroupSpecification private constructor(builder: Builder) {
    /**
     * Specifies an IAM execution role to be assumed by the instance group.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Specifies the name of the instance group.
     */
    public val instanceGroupName: kotlin.String? = builder.instanceGroupName
    /**
     * Specifies the instance type of the instance group.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = builder.instanceType
    /**
     * Specifies the LifeCycle configuration for the instance group.
     */
    public val lifeCycleConfig: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig? = builder.lifeCycleConfig
    /**
     * Specifies the value for **Threads per core**. For instance types that support multithreading, you can specify `1` for disabling multithreading and `2` for enabling multithreading. For instance types that doesn't support multithreading, specify `1`. For more information, see the reference table of [CPU cores and threads per CPU core per instance type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val threadsPerCore: kotlin.Int? = builder.threadsPerCore

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterInstanceGroupSpecification(")
        append("executionRole=$executionRole,")
        append("instanceCount=$instanceCount,")
        append("instanceGroupName=$instanceGroupName,")
        append("instanceType=$instanceType,")
        append("lifeCycleConfig=$lifeCycleConfig,")
        append("threadsPerCore=$threadsPerCore")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionRole?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceGroupName?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleConfig?.hashCode() ?: 0)
        result = 31 * result + (threadsPerCore ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterInstanceGroupSpecification

        if (executionRole != other.executionRole) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceGroupName != other.instanceGroupName) return false
        if (instanceType != other.instanceType) return false
        if (lifeCycleConfig != other.lifeCycleConfig) return false
        if (threadsPerCore != other.threadsPerCore) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies an IAM execution role to be assumed by the instance group.
         */
        public var executionRole: kotlin.String? = null
        /**
         * Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * Specifies the name of the instance group.
         */
        public var instanceGroupName: kotlin.String? = null
        /**
         * Specifies the instance type of the instance group.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = null
        /**
         * Specifies the LifeCycle configuration for the instance group.
         */
        public var lifeCycleConfig: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig? = null
        /**
         * Specifies the value for **Threads per core**. For instance types that support multithreading, you can specify `1` for disabling multithreading and `2` for enabling multithreading. For instance types that doesn't support multithreading, specify `1`. For more information, see the reference table of [CPU cores and threads per CPU core per instance type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var threadsPerCore: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupSpecification) : this() {
            this.executionRole = x.executionRole
            this.instanceCount = x.instanceCount
            this.instanceGroupName = x.instanceGroupName
            this.instanceType = x.instanceType
            this.lifeCycleConfig = x.lifeCycleConfig
            this.threadsPerCore = x.threadsPerCore
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupSpecification = ClusterInstanceGroupSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig] inside the given [block]
         */
        public fun lifeCycleConfig(block: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig.Builder.() -> kotlin.Unit) {
            this.lifeCycleConfig = aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
