// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelQualityAppSpecification
import aws.sdk.kotlin.services.sagemaker.model.ModelQualityBaselineConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelQualityJobInput
import aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringResources
import aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeModelQualityJobDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeModelQualityJobDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeModelQualityJobDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelQualityJobDefinitionError(context, call, payload)
        }
        val builder = DescribeModelQualityJobDefinitionResponse.Builder()

        if (payload != null) {
            deserializeDescribeModelQualityJobDefinitionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeModelQualityJobDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelQualityJobDefinitionOperationBody(builder: DescribeModelQualityJobDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val JOBDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionArn"))
    val JOBDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionName"))
    val JOBRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobResources"))
    val MODELQUALITYAPPSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelQualityAppSpecification"))
    val MODELQUALITYBASELINECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelQualityBaselineConfig"))
    val MODELQUALITYJOBINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelQualityJobInput"))
    val MODELQUALITYJOBOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelQualityJobOutputConfig"))
    val NETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(JOBDEFINITIONARN_DESCRIPTOR)
        field(JOBDEFINITIONNAME_DESCRIPTOR)
        field(JOBRESOURCES_DESCRIPTOR)
        field(MODELQUALITYAPPSPECIFICATION_DESCRIPTOR)
        field(MODELQUALITYBASELINECONFIG_DESCRIPTOR)
        field(MODELQUALITYJOBINPUT_DESCRIPTOR)
        field(MODELQUALITYJOBOUTPUTCONFIG_DESCRIPTOR)
        field(NETWORKCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBDEFINITIONARN_DESCRIPTOR.index -> builder.jobDefinitionArn = deserializeString()
                JOBDEFINITIONNAME_DESCRIPTOR.index -> builder.jobDefinitionName = deserializeString()
                JOBRESOURCES_DESCRIPTOR.index -> builder.jobResources = deserializeMonitoringResourcesDocument(deserializer)
                MODELQUALITYAPPSPECIFICATION_DESCRIPTOR.index -> builder.modelQualityAppSpecification = deserializeModelQualityAppSpecificationDocument(deserializer)
                MODELQUALITYBASELINECONFIG_DESCRIPTOR.index -> builder.modelQualityBaselineConfig = deserializeModelQualityBaselineConfigDocument(deserializer)
                MODELQUALITYJOBINPUT_DESCRIPTOR.index -> builder.modelQualityJobInput = deserializeModelQualityJobInputDocument(deserializer)
                MODELQUALITYJOBOUTPUTCONFIG_DESCRIPTOR.index -> builder.modelQualityJobOutputConfig = deserializeMonitoringOutputConfigDocument(deserializer)
                NETWORKCONFIG_DESCRIPTOR.index -> builder.networkConfig = deserializeMonitoringNetworkConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeMonitoringStoppingConditionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
