// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupDetails
import aws.sdk.kotlin.services.sagemaker.model.ClusterStatus
import aws.sdk.kotlin.services.sagemaker.model.DescribeClusterResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.VpcConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeClusterOperationDeserializer: HttpDeserializer.NonStreaming<DescribeClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeClusterError(context, call, payload)
        }
        val builder = DescribeClusterResponse.Builder()

        if (payload != null) {
            deserializeDescribeClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeClusterOperationBody(builder: DescribeClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterArn"))
    val CLUSTERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterName"))
    val CLUSTERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ClusterStatus"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureMessage"))
    val INSTANCEGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InstanceGroups"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERARN_DESCRIPTOR)
        field(CLUSTERNAME_DESCRIPTOR)
        field(CLUSTERSTATUS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREMESSAGE_DESCRIPTOR)
        field(INSTANCEGROUPS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                CLUSTERNAME_DESCRIPTOR.index -> builder.clusterName = deserializeString()
                CLUSTERSTATUS_DESCRIPTOR.index -> builder.clusterStatus = deserializeString().let { ClusterStatus.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FAILUREMESSAGE_DESCRIPTOR.index -> builder.failureMessage = deserializeString()
                INSTANCEGROUPS_DESCRIPTOR.index -> builder.instanceGroups =
                    deserializer.deserializeList(INSTANCEGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<ClusterInstanceGroupDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeClusterInstanceGroupDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
