// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.CodeEditorAppImageConfig
import aws.sdk.kotlin.services.sagemaker.model.DescribeAppImageConfigResponse
import aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppImageConfig
import aws.sdk.kotlin.services.sagemaker.model.KernelGatewayImageConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAppImageConfigOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAppImageConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAppImageConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAppImageConfigError(context, call, payload)
        }
        val builder = DescribeAppImageConfigResponse.Builder()

        if (payload != null) {
            deserializeDescribeAppImageConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAppImageConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAppImageConfigOperationBody(builder: DescribeAppImageConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPIMAGECONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppImageConfigArn"))
    val APPIMAGECONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppImageConfigName"))
    val CODEEDITORAPPIMAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CodeEditorAppImageConfig"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val JUPYTERLABAPPIMAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JupyterLabAppImageConfig"))
    val KERNELGATEWAYIMAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("KernelGatewayImageConfig"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPIMAGECONFIGARN_DESCRIPTOR)
        field(APPIMAGECONFIGNAME_DESCRIPTOR)
        field(CODEEDITORAPPIMAGECONFIG_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(JUPYTERLABAPPIMAGECONFIG_DESCRIPTOR)
        field(KERNELGATEWAYIMAGECONFIG_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPIMAGECONFIGARN_DESCRIPTOR.index -> builder.appImageConfigArn = deserializeString()
                APPIMAGECONFIGNAME_DESCRIPTOR.index -> builder.appImageConfigName = deserializeString()
                CODEEDITORAPPIMAGECONFIG_DESCRIPTOR.index -> builder.codeEditorAppImageConfig = deserializeCodeEditorAppImageConfigDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JUPYTERLABAPPIMAGECONFIG_DESCRIPTOR.index -> builder.jupyterLabAppImageConfig = deserializeJupyterLabAppImageConfigDocument(deserializer)
                KERNELGATEWAYIMAGECONFIG_DESCRIPTOR.index -> builder.kernelGatewayImageConfig = deserializeKernelGatewayImageConfigDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
