// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AlgorithmStatus
import aws.sdk.kotlin.services.sagemaker.model.AlgorithmStatusDetails
import aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationSpecification
import aws.sdk.kotlin.services.sagemaker.model.DescribeAlgorithmResponse
import aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAlgorithmOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAlgorithmResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAlgorithmResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAlgorithmError(context, call, payload)
        }
        val builder = DescribeAlgorithmResponse.Builder()

        if (payload != null) {
            deserializeDescribeAlgorithmOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAlgorithmError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAlgorithmOperationBody(builder: DescribeAlgorithmResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALGORITHMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmArn"))
    val ALGORITHMDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmDescription"))
    val ALGORITHMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmName"))
    val ALGORITHMSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AlgorithmStatus"))
    val ALGORITHMSTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlgorithmStatusDetails"))
    val CERTIFYFORMARKETPLACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CertifyForMarketplace"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val INFERENCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InferenceSpecification"))
    val PRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductId"))
    val TRAININGSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingSpecification"))
    val VALIDATIONSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMARN_DESCRIPTOR)
        field(ALGORITHMDESCRIPTION_DESCRIPTOR)
        field(ALGORITHMNAME_DESCRIPTOR)
        field(ALGORITHMSTATUS_DESCRIPTOR)
        field(ALGORITHMSTATUSDETAILS_DESCRIPTOR)
        field(CERTIFYFORMARKETPLACE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(INFERENCESPECIFICATION_DESCRIPTOR)
        field(PRODUCTID_DESCRIPTOR)
        field(TRAININGSPECIFICATION_DESCRIPTOR)
        field(VALIDATIONSPECIFICATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALGORITHMARN_DESCRIPTOR.index -> builder.algorithmArn = deserializeString()
                ALGORITHMDESCRIPTION_DESCRIPTOR.index -> builder.algorithmDescription = deserializeString()
                ALGORITHMNAME_DESCRIPTOR.index -> builder.algorithmName = deserializeString()
                ALGORITHMSTATUS_DESCRIPTOR.index -> builder.algorithmStatus = deserializeString().let { AlgorithmStatus.fromValue(it) }
                ALGORITHMSTATUSDETAILS_DESCRIPTOR.index -> builder.algorithmStatusDetails = deserializeAlgorithmStatusDetailsDocument(deserializer)
                CERTIFYFORMARKETPLACE_DESCRIPTOR.index -> builder.certifyForMarketplace = deserializeBoolean()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INFERENCESPECIFICATION_DESCRIPTOR.index -> builder.inferenceSpecification = deserializeInferenceSpecificationDocument(deserializer)
                PRODUCTID_DESCRIPTOR.index -> builder.productId = deserializeString()
                TRAININGSPECIFICATION_DESCRIPTOR.index -> builder.trainingSpecification = deserializeTrainingSpecificationDocument(deserializer)
                VALIDATIONSPECIFICATION_DESCRIPTOR.index -> builder.validationSpecification = deserializeAlgorithmValidationSpecificationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
