// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.CreateHubContentReferenceResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateHubContentReferenceOperationDeserializer: HttpDeserializer.NonStreaming<CreateHubContentReferenceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateHubContentReferenceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateHubContentReferenceError(context, call, payload)
        }
        val builder = CreateHubContentReferenceResponse.Builder()

        if (payload != null) {
            deserializeCreateHubContentReferenceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateHubContentReferenceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceInUse" -> ResourceInUseDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHubContentReferenceOperationBody(builder: CreateHubContentReferenceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HUBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubArn"))
    val HUBCONTENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HUBARN_DESCRIPTOR)
        field(HUBCONTENTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HUBARN_DESCRIPTOR.index -> builder.hubArn = deserializeString()
                HUBCONTENTARN_DESCRIPTOR.index -> builder.hubContentArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
