// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The VPC object you use to create or update a workforce.
 */
public class WorkforceVpcConfigRequest private constructor(builder: Builder) {
    /**
     * The VPC security group IDs, in the form `sg-xxxxxxxx`. The security groups must be for the same VPC as specified in the subnet.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnets in the VPC that you want to connect.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The ID of the VPC that the workforce uses for communication.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkforceVpcConfigRequest(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkforceVpcConfigRequest

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The VPC security group IDs, in the form `sg-xxxxxxxx`. The security groups must be for the same VPC as specified in the subnet.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnets in the VPC that you want to connect.
         */
        public var subnets: List<String>? = null
        /**
         * The ID of the VPC that the workforce uses for communication.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest = WorkforceVpcConfigRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
