// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the properties of a trial component. To get all the properties, call the [DescribeTrialComponent](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html) API and provide the `TrialComponentName`.
 */
public class TrialComponentSummary private constructor(builder: Builder) {
    /**
     * Who created the trial component.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * When the component was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the component as displayed. If `DisplayName` isn't specified, `TrialComponentName` is displayed.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * When the component ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Who last modified the component.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * When the component was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * When the component started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the component. States include:
     * + InProgress
     * + Completed
     * + Failed
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the trial component.
     */
    public val trialComponentArn: kotlin.String? = builder.trialComponentArn
    /**
     * The name of the trial component.
     */
    public val trialComponentName: kotlin.String? = builder.trialComponentName
    /**
     * The Amazon Resource Name (ARN) and job type of the source of a trial component.
     */
    public val trialComponentSource: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource? = builder.trialComponentSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrialComponentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrialComponentSummary(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("displayName=$displayName,")
        append("endTime=$endTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("trialComponentArn=$trialComponentArn,")
        append("trialComponentName=$trialComponentName,")
        append("trialComponentSource=$trialComponentSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trialComponentArn?.hashCode() ?: 0)
        result = 31 * result + (trialComponentName?.hashCode() ?: 0)
        result = 31 * result + (trialComponentSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrialComponentSummary

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (displayName != other.displayName) return false
        if (endTime != other.endTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (trialComponentArn != other.trialComponentArn) return false
        if (trialComponentName != other.trialComponentName) return false
        if (trialComponentSource != other.trialComponentSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrialComponentSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Who created the trial component.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the component was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the component as displayed. If `DisplayName` isn't specified, `TrialComponentName` is displayed.
         */
        public var displayName: kotlin.String? = null
        /**
         * When the component ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Who last modified the component.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the component was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When the component started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the component. States include:
         * + InProgress
         * + Completed
         * + Failed
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the trial component.
         */
        public var trialComponentArn: kotlin.String? = null
        /**
         * The name of the trial component.
         */
        public var trialComponentName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) and job type of the source of a trial component.
         */
        public var trialComponentSource: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSummary) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.displayName = x.displayName
            this.endTime = x.endTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.startTime = x.startTime
            this.status = x.status
            this.trialComponentArn = x.trialComponentArn
            this.trialComponentName = x.trialComponentName
            this.trialComponentSource = x.trialComponentSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrialComponentSummary = TrialComponentSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource] inside the given [block]
         */
        public fun trialComponentSource(block: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource.Builder.() -> kotlin.Unit) {
            this.trialComponentSource = aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
