// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of the production variant.
 */
public class ProductionVariantStatus private constructor(builder: Builder) {
    /**
     * The start time of the current status change.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The endpoint variant status which describes the current deployment stage status or operational status.
     * + `Creating`: Creating inference resources for the production variant.
     * + `Deleting`: Terminating inference resources for the production variant.
     * + `Updating`: Updating capacity for the production variant.
     * + `ActivatingTraffic`: Turning on traffic for the production variant.
     * + `Baking`: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.VariantStatus? = builder.status
    /**
     * A message that describes the status of the production variant.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProductionVariantStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductionVariantStatus(")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = startTime?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductionVariantStatus

        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProductionVariantStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The start time of the current status change.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The endpoint variant status which describes the current deployment stage status or operational status.
         * + `Creating`: Creating inference resources for the production variant.
         * + `Deleting`: Terminating inference resources for the production variant.
         * + `Updating`: Updating capacity for the production variant.
         * + `ActivatingTraffic`: Turning on traffic for the production variant.
         * + `Baking`: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.VariantStatus? = null
        /**
         * A message that describes the status of the production variant.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantStatus) : this() {
            this.startTime = x.startTime
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProductionVariantStatus = ProductionVariantStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
