// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration for downloading input data from Amazon S3 into the processing container.
 */
public class ProcessingS3Input private constructor(builder: Builder) {
    /**
     * The local path in your container where you want Amazon SageMaker to write input data to. `LocalPath` is an absolute path to the input data and must begin with `/opt/ml/processing/`. `LocalPath` is a required parameter when `AppManaged` is `False` (default).
     */
    public val localPath: kotlin.String? = builder.localPath
    /**
     * Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container. `Gzip` can only be used when `Pipe` mode is specified as the `S3InputMode`. In `Pipe` mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.
     */
    public val s3CompressionType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3CompressionType? = builder.s3CompressionType
    /**
     * Whether to distribute the data from Amazon S3 to all processing instances with `FullyReplicated`, or whether the data from Amazon S3 is shared by Amazon S3 key, downloading one shard of data to each processing instance.
     */
    public val s3DataDistributionType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3DataDistributionType? = builder.s3DataDistributionType
    /**
     * Whether you use an `S3Prefix` or a `ManifestFile` for the data type. If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose `ManifestFile`, `S3Uri` identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.
     */
    public val s3DataType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3DataType? = builder.s3DataType
    /**
     * Whether to use `File` or `Pipe` input mode. In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In `Pipe` mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.
     */
    public val s3InputMode: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3InputMode? = builder.s3InputMode
    /**
     * The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessingS3Input(")
        append("localPath=$localPath,")
        append("s3CompressionType=$s3CompressionType,")
        append("s3DataDistributionType=$s3DataDistributionType,")
        append("s3DataType=$s3DataType,")
        append("s3InputMode=$s3InputMode,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = localPath?.hashCode() ?: 0
        result = 31 * result + (s3CompressionType?.hashCode() ?: 0)
        result = 31 * result + (s3DataDistributionType?.hashCode() ?: 0)
        result = 31 * result + (s3DataType?.hashCode() ?: 0)
        result = 31 * result + (s3InputMode?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessingS3Input

        if (localPath != other.localPath) return false
        if (s3CompressionType != other.s3CompressionType) return false
        if (s3DataDistributionType != other.s3DataDistributionType) return false
        if (s3DataType != other.s3DataType) return false
        if (s3InputMode != other.s3InputMode) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The local path in your container where you want Amazon SageMaker to write input data to. `LocalPath` is an absolute path to the input data and must begin with `/opt/ml/processing/`. `LocalPath` is a required parameter when `AppManaged` is `False` (default).
         */
        public var localPath: kotlin.String? = null
        /**
         * Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container. `Gzip` can only be used when `Pipe` mode is specified as the `S3InputMode`. In `Pipe` mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.
         */
        public var s3CompressionType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3CompressionType? = null
        /**
         * Whether to distribute the data from Amazon S3 to all processing instances with `FullyReplicated`, or whether the data from Amazon S3 is shared by Amazon S3 key, downloading one shard of data to each processing instance.
         */
        public var s3DataDistributionType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3DataDistributionType? = null
        /**
         * Whether you use an `S3Prefix` or a `ManifestFile` for the data type. If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose `ManifestFile`, `S3Uri` identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.
         */
        public var s3DataType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3DataType? = null
        /**
         * Whether to use `File` or `Pipe` input mode. In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In `Pipe` mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.
         */
        public var s3InputMode: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3InputMode? = null
        /**
         * The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input) : this() {
            this.localPath = x.localPath
            this.s3CompressionType = x.s3CompressionType
            this.s3DataDistributionType = x.s3DataDistributionType
            this.s3DataType = x.s3DataType
            this.s3InputMode = x.s3InputMode
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Input = ProcessingS3Input(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
