// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details for where to store the optimized model that you create with the optimization job.
 */
public class OptimizationJobOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt the artifacts of the optimized model when SageMaker uploads the model to Amazon S3.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon S3 URI for where to store the optimized model that you create with an optimization job.
     */
    public val s3OutputLocation: kotlin.String? = builder.s3OutputLocation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptimizationJobOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("s3OutputLocation=$s3OutputLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (s3OutputLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptimizationJobOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (s3OutputLocation != other.s3OutputLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt the artifacts of the optimized model when SageMaker uploads the model to Amazon S3.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon S3 URI for where to store the optimized model that you create with an optimization job.
         */
        public var s3OutputLocation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.s3OutputLocation = x.s3OutputLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig = OptimizationJobOutputConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
