// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container image configuration object for the monitoring job.
 */
public class ModelQualityAppSpecification private constructor(builder: Builder) {
    /**
     * An array of arguments for the container used to run the monitoring job.
     */
    public val containerArguments: List<String>? = builder.containerArguments
    /**
     * Specifies the entrypoint for a container that the monitoring job runs.
     */
    public val containerEntrypoint: List<String>? = builder.containerEntrypoint
    /**
     * Sets the environment variables in the container that the monitoring job runs.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The address of the container image that the monitoring job runs.
     */
    public val imageUri: kotlin.String? = builder.imageUri
    /**
     * An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
     */
    public val postAnalyticsProcessorSourceUri: kotlin.String? = builder.postAnalyticsProcessorSourceUri
    /**
     * The machine learning problem type of the model that the monitoring job monitors.
     */
    public val problemType: aws.sdk.kotlin.services.sagemaker.model.MonitoringProblemType? = builder.problemType
    /**
     * An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
     */
    public val recordPreprocessorSourceUri: kotlin.String? = builder.recordPreprocessorSourceUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelQualityAppSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelQualityAppSpecification(")
        append("containerArguments=$containerArguments,")
        append("containerEntrypoint=$containerEntrypoint,")
        append("environment=$environment,")
        append("imageUri=$imageUri,")
        append("postAnalyticsProcessorSourceUri=$postAnalyticsProcessorSourceUri,")
        append("problemType=$problemType,")
        append("recordPreprocessorSourceUri=$recordPreprocessorSourceUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerArguments?.hashCode() ?: 0
        result = 31 * result + (containerEntrypoint?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (imageUri?.hashCode() ?: 0)
        result = 31 * result + (postAnalyticsProcessorSourceUri?.hashCode() ?: 0)
        result = 31 * result + (problemType?.hashCode() ?: 0)
        result = 31 * result + (recordPreprocessorSourceUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelQualityAppSpecification

        if (containerArguments != other.containerArguments) return false
        if (containerEntrypoint != other.containerEntrypoint) return false
        if (environment != other.environment) return false
        if (imageUri != other.imageUri) return false
        if (postAnalyticsProcessorSourceUri != other.postAnalyticsProcessorSourceUri) return false
        if (problemType != other.problemType) return false
        if (recordPreprocessorSourceUri != other.recordPreprocessorSourceUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelQualityAppSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of arguments for the container used to run the monitoring job.
         */
        public var containerArguments: List<String>? = null
        /**
         * Specifies the entrypoint for a container that the monitoring job runs.
         */
        public var containerEntrypoint: List<String>? = null
        /**
         * Sets the environment variables in the container that the monitoring job runs.
         */
        public var environment: Map<String, String>? = null
        /**
         * The address of the container image that the monitoring job runs.
         */
        public var imageUri: kotlin.String? = null
        /**
         * An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
         */
        public var postAnalyticsProcessorSourceUri: kotlin.String? = null
        /**
         * The machine learning problem type of the model that the monitoring job monitors.
         */
        public var problemType: aws.sdk.kotlin.services.sagemaker.model.MonitoringProblemType? = null
        /**
         * An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
         */
        public var recordPreprocessorSourceUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelQualityAppSpecification) : this() {
            this.containerArguments = x.containerArguments
            this.containerEntrypoint = x.containerEntrypoint
            this.environment = x.environment
            this.imageUri = x.imageUri
            this.postAnalyticsProcessorSourceUri = x.postAnalyticsProcessorSourceUri
            this.problemType = x.problemType
            this.recordPreprocessorSourceUri = x.recordPreprocessorSourceUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelQualityAppSpecification = ModelQualityAppSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
