// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The access configuration file to control access to the ML model. You can explicitly accept the model end-user license agreement (EULA) within the `ModelAccessConfig`.
 * + If you are a Jumpstart user, see the [End-user license agreements](https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-foundation-models-choose.html#jumpstart-foundation-models-choose-eula) section for more details on accepting the EULA.
 * + If you are an AutoML user, see the *Optional Parameters* section of *Create an AutoML job to fine-tune text generation models using the API* for details on [How to set the EULA acceptance when fine-tuning a model using the AutoML API](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-finetune-llms.html#autopilot-llms-finetuning-api-optional-params).
 */
public class ModelAccessConfig private constructor(builder: Builder) {
    /**
     * Specifies agreement to the model end-user license agreement (EULA). The `AcceptEula` value must be explicitly defined as `True` in order to accept the EULA that this model requires. You are responsible for reviewing and complying with any applicable license terms and making sure they are acceptable for your use case before downloading or using a model.
     */
    public val acceptEula: kotlin.Boolean? = builder.acceptEula

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelAccessConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelAccessConfig(")
        append("acceptEula=$acceptEula")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptEula?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelAccessConfig

        if (acceptEula != other.acceptEula) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelAccessConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies agreement to the model end-user license agreement (EULA). The `AcceptEula` value must be explicitly defined as `True` in order to accept the EULA that this model requires. You are responsible for reviewing and complying with any applicable license terms and making sure they are acceptable for your use case before downloading or using a model.
         */
        public var acceptEula: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelAccessConfig) : this() {
            this.acceptEula = x.acceptEula
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelAccessConfig = ModelAccessConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
