// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the resources that are deployed with this inference component.
 */
public class InferenceComponentContainerSpecificationSummary private constructor(builder: Builder) {
    /**
     * The Amazon S3 path where the model artifacts are stored.
     */
    public val artifactUrl: kotlin.String? = builder.artifactUrl
    /**
     * Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this [ProductionVariant](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html).
     *
     * If you used the `registry/repository[:tag]` form to specify the image path of the primary container when you created the model hosted in this `ProductionVariant`, the path resolves to a path of the form `registry/repository[@digest]`. A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see [Pulling an Image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html) in the *Amazon ECR User Guide*.
     */
    public val deployedImage: aws.sdk.kotlin.services.sagemaker.model.DeployedImage? = builder.deployedImage
    /**
     * The environment variables to set in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecificationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentContainerSpecificationSummary(")
        append("artifactUrl=$artifactUrl,")
        append("deployedImage=$deployedImage,")
        append("environment=$environment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactUrl?.hashCode() ?: 0
        result = 31 * result + (deployedImage?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentContainerSpecificationSummary

        if (artifactUrl != other.artifactUrl) return false
        if (deployedImage != other.deployedImage) return false
        if (environment != other.environment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecificationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 path where the model artifacts are stored.
         */
        public var artifactUrl: kotlin.String? = null
        /**
         * Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this [ProductionVariant](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html).
         *
         * If you used the `registry/repository[:tag]` form to specify the image path of the primary container when you created the model hosted in this `ProductionVariant`, the path resolves to a path of the form `registry/repository[@digest]`. A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see [Pulling an Image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html) in the *Amazon ECR User Guide*.
         */
        public var deployedImage: aws.sdk.kotlin.services.sagemaker.model.DeployedImage? = null
        /**
         * The environment variables to set in the Docker container.
         */
        public var environment: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecificationSummary) : this() {
            this.artifactUrl = x.artifactUrl
            this.deployedImage = x.deployedImage
            this.environment = x.environment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecificationSummary = InferenceComponentContainerSpecificationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DeployedImage] inside the given [block]
         */
        public fun deployedImage(block: aws.sdk.kotlin.services.sagemaker.model.DeployedImage.Builder.() -> kotlin.Unit) {
            this.deployedImage = aws.sdk.kotlin.services.sagemaker.model.DeployedImage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
