// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Stores the holiday featurization attributes applicable to each item of time-series datasets during the training of a forecasting model. This allows the model to identify patterns associated with specific holidays.
 */
public class HolidayConfigAttributes private constructor(builder: Builder) {
    /**
     * The country code for the holiday calendar.
     *
     * For the list of public holiday calendars supported by AutoML job V2, see [Country Codes](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes). Use the country code corresponding to the country of your choice.
     */
    public val countryCode: kotlin.String? = builder.countryCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HolidayConfigAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HolidayConfigAttributes(")
        append("countryCode=$countryCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = countryCode?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HolidayConfigAttributes

        if (countryCode != other.countryCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HolidayConfigAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The country code for the holiday calendar.
         *
         * For the list of public holiday calendars supported by AutoML job V2, see [Country Codes](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes). Use the country code corresponding to the country of your choice.
         */
        public var countryCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HolidayConfigAttributes) : this() {
            this.countryCode = x.countryCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HolidayConfigAttributes = HolidayConfigAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
