// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeFeatureGroupResponse private constructor(builder: Builder) {
    /**
     * A timestamp indicating when SageMaker created the `FeatureGroup`.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A free form description of the feature group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup`.
     *
     *  An `EventTime` is a point in time when a new event occurs that corresponds to the creation or update of a `Record` in a `FeatureGroup`. All `Records` in the `FeatureGroup` have a corresponding `EventTime`.
     */
    public val eventTimeFeatureName: kotlin.String? = builder.eventTimeFeatureName
    /**
     * The reason that the `FeatureGroup` failed to be replicated in the `OfflineStore`. This is failure can occur because:
     * + The `FeatureGroup` could not be created in the `OfflineStore`.
     * + The `FeatureGroup` could not be deleted from the `OfflineStore`.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * A list of the `Features` in the `FeatureGroup`. Each feature is defined by a `FeatureName` and `FeatureType`.
     */
    public val featureDefinitions: List<FeatureDefinition>? = builder.featureDefinitions
    /**
     * The Amazon Resource Name (ARN) of the `FeatureGroup`.
     */
    public val featureGroupArn: kotlin.String? = builder.featureGroupArn
    /**
     * he name of the `FeatureGroup`.
     */
    public val featureGroupName: kotlin.String? = builder.featureGroupName
    /**
     * The status of the feature group.
     */
    public val featureGroupStatus: aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus? = builder.featureGroupStatus
    /**
     * A timestamp indicating when the feature group was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A value indicating whether the update made to the feature group was successful.
     */
    public val lastUpdateStatus: aws.sdk.kotlin.services.sagemaker.model.LastUpdateStatus? = builder.lastUpdateStatus
    /**
     * A token to resume pagination of the list of `Features` (`FeatureDefinitions`).
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The configuration of the offline store. It includes the following configurations:
     * + Amazon S3 location of the offline store.
     * + Configuration of the Glue data catalog.
     * + Table format of the offline store.
     * + Option to disable the automatic creation of a Glue table for the offline store.
     * + Encryption configuration.
     */
    public val offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = builder.offlineStoreConfig
    /**
     * The status of the `OfflineStore`. Notifies you if replicating data into the `OfflineStore` has failed. Returns either: `Active` or `Blocked`
     */
    public val offlineStoreStatus: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus? = builder.offlineStoreStatus
    /**
     * The configuration for the `OnlineStore`.
     */
    public val onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = builder.onlineStoreConfig
    /**
     * The size of the `OnlineStore` in bytes.
     */
    public val onlineStoreTotalSizeBytes: kotlin.Long? = builder.onlineStoreTotalSizeBytes
    /**
     * The name of the `Feature` used for `RecordIdentifier`, whose value uniquely identifies a record stored in the feature store.
     */
    public val recordIdentifierFeatureName: kotlin.String? = builder.recordIdentifierFeatureName
    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the OfflineStore if an OfflineStoreConfig is provided.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Active throughput configuration of the feature group. There are two modes: `ON_DEMAND` and `PROVISIONED`. With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
     *
     * Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the `Standard`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
     */
    public val throughputConfig: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription? = builder.throughputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFeatureGroupResponse(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("eventTimeFeatureName=$eventTimeFeatureName,")
        append("failureReason=$failureReason,")
        append("featureDefinitions=$featureDefinitions,")
        append("featureGroupArn=$featureGroupArn,")
        append("featureGroupName=$featureGroupName,")
        append("featureGroupStatus=$featureGroupStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("lastUpdateStatus=$lastUpdateStatus,")
        append("nextToken=$nextToken,")
        append("offlineStoreConfig=$offlineStoreConfig,")
        append("offlineStoreStatus=$offlineStoreStatus,")
        append("onlineStoreConfig=$onlineStoreConfig,")
        append("onlineStoreTotalSizeBytes=$onlineStoreTotalSizeBytes,")
        append("recordIdentifierFeatureName=$recordIdentifierFeatureName,")
        append("roleArn=$roleArn,")
        append("throughputConfig=$throughputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventTimeFeatureName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (featureDefinitions?.hashCode() ?: 0)
        result = 31 * result + (featureGroupArn?.hashCode() ?: 0)
        result = 31 * result + (featureGroupName?.hashCode() ?: 0)
        result = 31 * result + (featureGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreStatus?.hashCode() ?: 0)
        result = 31 * result + (onlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (onlineStoreTotalSizeBytes?.hashCode() ?: 0)
        result = 31 * result + (recordIdentifierFeatureName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (throughputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFeatureGroupResponse

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (eventTimeFeatureName != other.eventTimeFeatureName) return false
        if (failureReason != other.failureReason) return false
        if (featureDefinitions != other.featureDefinitions) return false
        if (featureGroupArn != other.featureGroupArn) return false
        if (featureGroupName != other.featureGroupName) return false
        if (featureGroupStatus != other.featureGroupStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (lastUpdateStatus != other.lastUpdateStatus) return false
        if (nextToken != other.nextToken) return false
        if (offlineStoreConfig != other.offlineStoreConfig) return false
        if (offlineStoreStatus != other.offlineStoreStatus) return false
        if (onlineStoreConfig != other.onlineStoreConfig) return false
        if (onlineStoreTotalSizeBytes != other.onlineStoreTotalSizeBytes) return false
        if (recordIdentifierFeatureName != other.recordIdentifierFeatureName) return false
        if (roleArn != other.roleArn) return false
        if (throughputConfig != other.throughputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A timestamp indicating when SageMaker created the `FeatureGroup`.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A free form description of the feature group.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup`.
         *
         *  An `EventTime` is a point in time when a new event occurs that corresponds to the creation or update of a `Record` in a `FeatureGroup`. All `Records` in the `FeatureGroup` have a corresponding `EventTime`.
         */
        public var eventTimeFeatureName: kotlin.String? = null
        /**
         * The reason that the `FeatureGroup` failed to be replicated in the `OfflineStore`. This is failure can occur because:
         * + The `FeatureGroup` could not be created in the `OfflineStore`.
         * + The `FeatureGroup` could not be deleted from the `OfflineStore`.
         */
        public var failureReason: kotlin.String? = null
        /**
         * A list of the `Features` in the `FeatureGroup`. Each feature is defined by a `FeatureName` and `FeatureType`.
         */
        public var featureDefinitions: List<FeatureDefinition>? = null
        /**
         * The Amazon Resource Name (ARN) of the `FeatureGroup`.
         */
        public var featureGroupArn: kotlin.String? = null
        /**
         * he name of the `FeatureGroup`.
         */
        public var featureGroupName: kotlin.String? = null
        /**
         * The status of the feature group.
         */
        public var featureGroupStatus: aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus? = null
        /**
         * A timestamp indicating when the feature group was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value indicating whether the update made to the feature group was successful.
         */
        public var lastUpdateStatus: aws.sdk.kotlin.services.sagemaker.model.LastUpdateStatus? = null
        /**
         * A token to resume pagination of the list of `Features` (`FeatureDefinitions`).
         */
        public var nextToken: kotlin.String? = null
        /**
         * The configuration of the offline store. It includes the following configurations:
         * + Amazon S3 location of the offline store.
         * + Configuration of the Glue data catalog.
         * + Table format of the offline store.
         * + Option to disable the automatic creation of a Glue table for the offline store.
         * + Encryption configuration.
         */
        public var offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = null
        /**
         * The status of the `OfflineStore`. Notifies you if replicating data into the `OfflineStore` has failed. Returns either: `Active` or `Blocked`
         */
        public var offlineStoreStatus: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus? = null
        /**
         * The configuration for the `OnlineStore`.
         */
        public var onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = null
        /**
         * The size of the `OnlineStore` in bytes.
         */
        public var onlineStoreTotalSizeBytes: kotlin.Long? = null
        /**
         * The name of the `Feature` used for `RecordIdentifier`, whose value uniquely identifies a record stored in the feature store.
         */
        public var recordIdentifierFeatureName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the OfflineStore if an OfflineStoreConfig is provided.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Active throughput configuration of the feature group. There are two modes: `ON_DEMAND` and `PROVISIONED`. With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
         *
         * Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the `Standard`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
         */
        public var throughputConfig: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.eventTimeFeatureName = x.eventTimeFeatureName
            this.failureReason = x.failureReason
            this.featureDefinitions = x.featureDefinitions
            this.featureGroupArn = x.featureGroupArn
            this.featureGroupName = x.featureGroupName
            this.featureGroupStatus = x.featureGroupStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.lastUpdateStatus = x.lastUpdateStatus
            this.nextToken = x.nextToken
            this.offlineStoreConfig = x.offlineStoreConfig
            this.offlineStoreStatus = x.offlineStoreStatus
            this.onlineStoreConfig = x.onlineStoreConfig
            this.onlineStoreTotalSizeBytes = x.onlineStoreTotalSizeBytes
            this.recordIdentifierFeatureName = x.recordIdentifierFeatureName
            this.roleArn = x.roleArn
            this.throughputConfig = x.throughputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse = DescribeFeatureGroupResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LastUpdateStatus] inside the given [block]
         */
        public fun lastUpdateStatus(block: aws.sdk.kotlin.services.sagemaker.model.LastUpdateStatus.Builder.() -> kotlin.Unit) {
            this.lastUpdateStatus = aws.sdk.kotlin.services.sagemaker.model.LastUpdateStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig] inside the given [block]
         */
        public fun offlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.Builder.() -> kotlin.Unit) {
            this.offlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus] inside the given [block]
         */
        public fun offlineStoreStatus(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus.Builder.() -> kotlin.Unit) {
            this.offlineStoreStatus = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig] inside the given [block]
         */
        public fun onlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.Builder.() -> kotlin.Unit) {
            this.onlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription] inside the given [block]
         */
        public fun throughputConfig(block: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription.Builder.() -> kotlin.Unit) {
            this.throughputConfig = aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
