// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeUserProfileResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserProfileStatus
import aws.sdk.kotlin.services.sagemaker.model.UserSettings
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeUserProfileOperationDeserializer: HttpDeserializer.NonStreaming<DescribeUserProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeUserProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeUserProfileError(context, call, payload)
        }
        val builder = DescribeUserProfileResponse.Builder()

        if (payload != null) {
            deserializeDescribeUserProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeUserProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUserProfileOperationBody(builder: DescribeUserProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HOMEEFSFILESYSTEMUID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HomeEfsFileSystemUid"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val SINGLESIGNONUSERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SingleSignOnUserIdentifier"))
    val SINGLESIGNONUSERVALUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SingleSignOnUserValue"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val USERPROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserProfileArn"))
    val USERPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserProfileName"))
    val USERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HOMEEFSFILESYSTEMUID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(SINGLESIGNONUSERIDENTIFIER_DESCRIPTOR)
        field(SINGLESIGNONUSERVALUE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERPROFILEARN_DESCRIPTOR)
        field(USERPROFILENAME_DESCRIPTOR)
        field(USERSETTINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HOMEEFSFILESYSTEMUID_DESCRIPTOR.index -> builder.homeEfsFileSystemUid = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SINGLESIGNONUSERIDENTIFIER_DESCRIPTOR.index -> builder.singleSignOnUserIdentifier = deserializeString()
                SINGLESIGNONUSERVALUE_DESCRIPTOR.index -> builder.singleSignOnUserValue = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { UserProfileStatus.fromValue(it) }
                USERPROFILEARN_DESCRIPTOR.index -> builder.userProfileArn = deserializeString()
                USERPROFILENAME_DESCRIPTOR.index -> builder.userProfileName = deserializeString()
                USERSETTINGS_DESCRIPTOR.index -> builder.userSettings = deserializeUserSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
