// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification
import aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput
import aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringResources
import aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeModelBiasJobDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeModelBiasJobDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeModelBiasJobDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelBiasJobDefinitionError(context, call, payload)
        }
        val builder = DescribeModelBiasJobDefinitionResponse.Builder()

        if (payload != null) {
            deserializeDescribeModelBiasJobDefinitionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeModelBiasJobDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelBiasJobDefinitionOperationBody(builder: DescribeModelBiasJobDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val JOBDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionArn"))
    val JOBDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionName"))
    val JOBRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobResources"))
    val MODELBIASAPPSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelBiasAppSpecification"))
    val MODELBIASBASELINECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelBiasBaselineConfig"))
    val MODELBIASJOBINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelBiasJobInput"))
    val MODELBIASJOBOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelBiasJobOutputConfig"))
    val NETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(JOBDEFINITIONARN_DESCRIPTOR)
        field(JOBDEFINITIONNAME_DESCRIPTOR)
        field(JOBRESOURCES_DESCRIPTOR)
        field(MODELBIASAPPSPECIFICATION_DESCRIPTOR)
        field(MODELBIASBASELINECONFIG_DESCRIPTOR)
        field(MODELBIASJOBINPUT_DESCRIPTOR)
        field(MODELBIASJOBOUTPUTCONFIG_DESCRIPTOR)
        field(NETWORKCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                JOBDEFINITIONARN_DESCRIPTOR.index -> builder.jobDefinitionArn = deserializeString()
                JOBDEFINITIONNAME_DESCRIPTOR.index -> builder.jobDefinitionName = deserializeString()
                JOBRESOURCES_DESCRIPTOR.index -> builder.jobResources = deserializeMonitoringResourcesDocument(deserializer)
                MODELBIASAPPSPECIFICATION_DESCRIPTOR.index -> builder.modelBiasAppSpecification = deserializeModelBiasAppSpecificationDocument(deserializer)
                MODELBIASBASELINECONFIG_DESCRIPTOR.index -> builder.modelBiasBaselineConfig = deserializeModelBiasBaselineConfigDocument(deserializer)
                MODELBIASJOBINPUT_DESCRIPTOR.index -> builder.modelBiasJobInput = deserializeModelBiasJobInputDocument(deserializer)
                MODELBIASJOBOUTPUTCONFIG_DESCRIPTOR.index -> builder.modelBiasJobOutputConfig = deserializeMonitoringOutputConfigDocument(deserializer)
                NETWORKCONFIG_DESCRIPTOR.index -> builder.networkConfig = deserializeMonitoringNetworkConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeMonitoringStoppingConditionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
