// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see [Create a Private Workforce](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
 */
public class Workforce private constructor(builder: Builder) {
    /**
     * The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single [ Amazon Cognito user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
     */
    public val cognitoConfig: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig? = builder.cognitoConfig
    /**
     * The date that the workforce is created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The reason your workforce failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The most recent date that [UpdateWorkforce](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateWorkforce.html) was used to successfully add one or more IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to a private workforce's allow list.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * The configuration of an OIDC Identity Provider (IdP) private workforce.
     */
    public val oidcConfig: aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse? = builder.oidcConfig
    /**
     * A list of one to ten IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to be added to the workforce allow list. By default, a workforce isn't restricted to specific IP addresses.
     */
    public val sourceIpConfig: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig? = builder.sourceIpConfig
    /**
     * The status of your workforce.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.WorkforceStatus? = builder.status
    /**
     * The subdomain for your OIDC Identity Provider.
     */
    public val subDomain: kotlin.String? = builder.subDomain
    /**
     * The Amazon Resource Name (ARN) of the private workforce.
     */
    public val workforceArn: kotlin.String? = builder.workforceArn
    /**
     * The name of the private workforce.
     */
    public val workforceName: kotlin.String? = builder.workforceName
    /**
     * The configuration of a VPC workforce.
     */
    public val workforceVpcConfig: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigResponse? = builder.workforceVpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Workforce = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workforce(")
        append("cognitoConfig=$cognitoConfig,")
        append("createDate=$createDate,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("oidcConfig=$oidcConfig,")
        append("sourceIpConfig=$sourceIpConfig,")
        append("status=$status,")
        append("subDomain=$subDomain,")
        append("workforceArn=$workforceArn,")
        append("workforceName=$workforceName,")
        append("workforceVpcConfig=$workforceVpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cognitoConfig?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (oidcConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceIpConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subDomain?.hashCode() ?: 0)
        result = 31 * result + (workforceArn?.hashCode() ?: 0)
        result = 31 * result + (workforceName?.hashCode() ?: 0)
        result = 31 * result + (workforceVpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workforce

        if (cognitoConfig != other.cognitoConfig) return false
        if (createDate != other.createDate) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (oidcConfig != other.oidcConfig) return false
        if (sourceIpConfig != other.sourceIpConfig) return false
        if (status != other.status) return false
        if (subDomain != other.subDomain) return false
        if (workforceArn != other.workforceArn) return false
        if (workforceName != other.workforceName) return false
        if (workforceVpcConfig != other.workforceVpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Workforce = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single [ Amazon Cognito user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
         */
        public var cognitoConfig: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig? = null
        /**
         * The date that the workforce is created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason your workforce failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The most recent date that [UpdateWorkforce](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateWorkforce.html) was used to successfully add one or more IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to a private workforce's allow list.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration of an OIDC Identity Provider (IdP) private workforce.
         */
        public var oidcConfig: aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse? = null
        /**
         * A list of one to ten IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to be added to the workforce allow list. By default, a workforce isn't restricted to specific IP addresses.
         */
        public var sourceIpConfig: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig? = null
        /**
         * The status of your workforce.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.WorkforceStatus? = null
        /**
         * The subdomain for your OIDC Identity Provider.
         */
        public var subDomain: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the private workforce.
         */
        public var workforceArn: kotlin.String? = null
        /**
         * The name of the private workforce.
         */
        public var workforceName: kotlin.String? = null
        /**
         * The configuration of a VPC workforce.
         */
        public var workforceVpcConfig: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Workforce) : this() {
            this.cognitoConfig = x.cognitoConfig
            this.createDate = x.createDate
            this.failureReason = x.failureReason
            this.lastUpdatedDate = x.lastUpdatedDate
            this.oidcConfig = x.oidcConfig
            this.sourceIpConfig = x.sourceIpConfig
            this.status = x.status
            this.subDomain = x.subDomain
            this.workforceArn = x.workforceArn
            this.workforceName = x.workforceName
            this.workforceVpcConfig = x.workforceVpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Workforce = Workforce(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CognitoConfig] inside the given [block]
         */
        public fun cognitoConfig(block: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig.Builder.() -> kotlin.Unit) {
            this.cognitoConfig = aws.sdk.kotlin.services.sagemaker.model.CognitoConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse] inside the given [block]
         */
        public fun oidcConfig(block: aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse.Builder.() -> kotlin.Unit) {
            this.oidcConfig = aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig] inside the given [block]
         */
        public fun sourceIpConfig(block: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig.Builder.() -> kotlin.Unit) {
            this.sourceIpConfig = aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigResponse] inside the given [block]
         */
        public fun workforceVpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigResponse.Builder.() -> kotlin.Unit) {
            this.workforceVpcConfig = aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
