// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in Amazon Web Services Marketplace that you are subscribed to.
 */
public class SourceAlgorithm private constructor(builder: Builder) {
    /**
     * The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in Amazon Web Services Marketplace that you are subscribed to.
     */
    public val algorithmName: kotlin.String? = builder.algorithmName
    /**
     * Specifies the location of ML model data to deploy during endpoint creation.
     */
    public val modelDataSource: aws.sdk.kotlin.services.sagemaker.model.ModelDataSource? = builder.modelDataSource
    /**
     * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single `gzip` compressed tar archive (`.tar.gz` suffix).
     *
     * The model artifacts must be in an S3 bucket that is in the same Amazon Web Services region as the algorithm.
     */
    public val modelDataUrl: kotlin.String? = builder.modelDataUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceAlgorithm(")
        append("algorithmName=$algorithmName,")
        append("modelDataSource=$modelDataSource,")
        append("modelDataUrl=$modelDataUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmName?.hashCode() ?: 0
        result = 31 * result + (modelDataSource?.hashCode() ?: 0)
        result = 31 * result + (modelDataUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceAlgorithm

        if (algorithmName != other.algorithmName) return false
        if (modelDataSource != other.modelDataSource) return false
        if (modelDataUrl != other.modelDataUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in Amazon Web Services Marketplace that you are subscribed to.
         */
        public var algorithmName: kotlin.String? = null
        /**
         * Specifies the location of ML model data to deploy during endpoint creation.
         */
        public var modelDataSource: aws.sdk.kotlin.services.sagemaker.model.ModelDataSource? = null
        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single `gzip` compressed tar archive (`.tar.gz` suffix).
         *
         * The model artifacts must be in an S3 bucket that is in the same Amazon Web Services region as the algorithm.
         */
        public var modelDataUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm) : this() {
            this.algorithmName = x.algorithmName
            this.modelDataSource = x.modelDataSource
            this.modelDataUrl = x.modelDataUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithm = SourceAlgorithm(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelDataSource] inside the given [block]
         */
        public fun modelDataSource(block: aws.sdk.kotlin.services.sagemaker.model.ModelDataSource.Builder.() -> kotlin.Unit) {
            this.modelDataSource = aws.sdk.kotlin.services.sagemaker.model.ModelDataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
