// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The selective execution configuration applied to the pipeline run.
 */
public class SelectiveExecutionConfig private constructor(builder: Builder) {
    /**
     * A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be included.
     */
    public val selectedSteps: List<SelectedStep>? = builder.selectedSteps
    /**
     * The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for the selected steps to run. The execution status of the pipeline can be either `Failed` or `Success`.
     *
     * This field is required if the steps you specify for `SelectedSteps` depend on output collaterals from any non-specified pipeline steps. For more information, see [Selective Execution for Pipeline Steps](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html).
     */
    public val sourcePipelineExecutionArn: kotlin.String? = builder.sourcePipelineExecutionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SelectiveExecutionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelectiveExecutionConfig(")
        append("selectedSteps=$selectedSteps,")
        append("sourcePipelineExecutionArn=$sourcePipelineExecutionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = selectedSteps?.hashCode() ?: 0
        result = 31 * result + (sourcePipelineExecutionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelectiveExecutionConfig

        if (selectedSteps != other.selectedSteps) return false
        if (sourcePipelineExecutionArn != other.sourcePipelineExecutionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SelectiveExecutionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be included.
         */
        public var selectedSteps: List<SelectedStep>? = null
        /**
         * The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for the selected steps to run. The execution status of the pipeline can be either `Failed` or `Success`.
         *
         * This field is required if the steps you specify for `SelectedSteps` depend on output collaterals from any non-specified pipeline steps. For more information, see [Selective Execution for Pipeline Steps](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html).
         */
        public var sourcePipelineExecutionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SelectiveExecutionConfig) : this() {
            this.selectedSteps = x.selectedSteps
            this.sourcePipelineExecutionArn = x.sourcePipelineExecutionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SelectiveExecutionConfig = SelectiveExecutionConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
