// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The output configuration for monitoring jobs.
 */
public class MonitoringOutputConfig private constructor(builder: Builder) {
    /**
     * The Key Management Service (KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
     */
    public val monitoringOutputs: List<MonitoringOutput>? = builder.monitoringOutputs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("monitoringOutputs=$monitoringOutputs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (monitoringOutputs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (monitoringOutputs != other.monitoringOutputs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Key Management Service (KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
         */
        public var monitoringOutputs: List<MonitoringOutput>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.monitoringOutputs = x.monitoringOutputs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig = MonitoringOutputConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
