// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the Docker container for the model package.
 */
public class ModelPackageContainerDefinition private constructor(builder: Builder) {
    /**
     * The additional data source that is used during inference in the Docker container for your model package.
     */
    public val additionalS3DataSource: aws.sdk.kotlin.services.sagemaker.model.AdditionalS3DataSource? = builder.additionalS3DataSource
    /**
     * The DNS host name for the Docker container.
     */
    public val containerHostname: kotlin.String? = builder.containerHostname
    /**
     * The environment variables to set in the Docker container. Each key and value in the `Environment` string to string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The machine learning framework of the model package container image.
     */
    public val framework: kotlin.String? = builder.framework
    /**
     * The framework version of the Model Package Container Image.
     */
    public val frameworkVersion: kotlin.String? = builder.frameworkVersion
    /**
     * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
     *
     * If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
     */
    public val image: kotlin.String? = builder.image
    /**
     * An MD5 hash of the training algorithm that identifies the Docker image used for training.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * Specifies the location of ML model data to deploy during endpoint creation.
     */
    public val modelDataSource: aws.sdk.kotlin.services.sagemaker.model.ModelDataSource? = builder.modelDataSource
    /**
     * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single `gzip` compressed tar archive (`.tar.gz` suffix).
     *
     * The model artifacts must be in an S3 bucket that is in the same region as the model package.
     */
    public val modelDataUrl: kotlin.String? = builder.modelDataUrl
    /**
     * A structure with Model Input details.
     */
    public val modelInput: aws.sdk.kotlin.services.sagemaker.model.ModelInput? = builder.modelInput
    /**
     * The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model. You can find a list of benchmarked models by calling `ListModelMetadata`.
     */
    public val nearestModelName: kotlin.String? = builder.nearestModelName
    /**
     * The Amazon Web Services Marketplace product ID of the model package.
     */
    public val productId: kotlin.String? = builder.productId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackageContainerDefinition(")
        append("additionalS3DataSource=$additionalS3DataSource,")
        append("containerHostname=$containerHostname,")
        append("environment=$environment,")
        append("framework=$framework,")
        append("frameworkVersion=$frameworkVersion,")
        append("image=$image,")
        append("imageDigest=$imageDigest,")
        append("modelDataSource=$modelDataSource,")
        append("modelDataUrl=$modelDataUrl,")
        append("modelInput=$modelInput,")
        append("nearestModelName=$nearestModelName,")
        append("productId=$productId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalS3DataSource?.hashCode() ?: 0
        result = 31 * result + (containerHostname?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (frameworkVersion?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (modelDataSource?.hashCode() ?: 0)
        result = 31 * result + (modelDataUrl?.hashCode() ?: 0)
        result = 31 * result + (modelInput?.hashCode() ?: 0)
        result = 31 * result + (nearestModelName?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackageContainerDefinition

        if (additionalS3DataSource != other.additionalS3DataSource) return false
        if (containerHostname != other.containerHostname) return false
        if (environment != other.environment) return false
        if (framework != other.framework) return false
        if (frameworkVersion != other.frameworkVersion) return false
        if (image != other.image) return false
        if (imageDigest != other.imageDigest) return false
        if (modelDataSource != other.modelDataSource) return false
        if (modelDataUrl != other.modelDataUrl) return false
        if (modelInput != other.modelInput) return false
        if (nearestModelName != other.nearestModelName) return false
        if (productId != other.productId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The additional data source that is used during inference in the Docker container for your model package.
         */
        public var additionalS3DataSource: aws.sdk.kotlin.services.sagemaker.model.AdditionalS3DataSource? = null
        /**
         * The DNS host name for the Docker container.
         */
        public var containerHostname: kotlin.String? = null
        /**
         * The environment variables to set in the Docker container. Each key and value in the `Environment` string to string map can have length of up to 1024. We support up to 16 entries in the map.
         */
        public var environment: Map<String, String>? = null
        /**
         * The machine learning framework of the model package container image.
         */
        public var framework: kotlin.String? = null
        /**
         * The framework version of the Model Package Container Image.
         */
        public var frameworkVersion: kotlin.String? = null
        /**
         * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
         *
         * If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
         */
        public var image: kotlin.String? = null
        /**
         * An MD5 hash of the training algorithm that identifies the Docker image used for training.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * Specifies the location of ML model data to deploy during endpoint creation.
         */
        public var modelDataSource: aws.sdk.kotlin.services.sagemaker.model.ModelDataSource? = null
        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single `gzip` compressed tar archive (`.tar.gz` suffix).
         *
         * The model artifacts must be in an S3 bucket that is in the same region as the model package.
         */
        public var modelDataUrl: kotlin.String? = null
        /**
         * A structure with Model Input details.
         */
        public var modelInput: aws.sdk.kotlin.services.sagemaker.model.ModelInput? = null
        /**
         * The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model. You can find a list of benchmarked models by calling `ListModelMetadata`.
         */
        public var nearestModelName: kotlin.String? = null
        /**
         * The Amazon Web Services Marketplace product ID of the model package.
         */
        public var productId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition) : this() {
            this.additionalS3DataSource = x.additionalS3DataSource
            this.containerHostname = x.containerHostname
            this.environment = x.environment
            this.framework = x.framework
            this.frameworkVersion = x.frameworkVersion
            this.image = x.image
            this.imageDigest = x.imageDigest
            this.modelDataSource = x.modelDataSource
            this.modelDataUrl = x.modelDataUrl
            this.modelInput = x.modelInput
            this.nearestModelName = x.nearestModelName
            this.productId = x.productId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition = ModelPackageContainerDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AdditionalS3DataSource] inside the given [block]
         */
        public fun additionalS3DataSource(block: aws.sdk.kotlin.services.sagemaker.model.AdditionalS3DataSource.Builder.() -> kotlin.Unit) {
            this.additionalS3DataSource = aws.sdk.kotlin.services.sagemaker.model.AdditionalS3DataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelDataSource] inside the given [block]
         */
        public fun modelDataSource(block: aws.sdk.kotlin.services.sagemaker.model.ModelDataSource.Builder.() -> kotlin.Unit) {
            this.modelDataSource = aws.sdk.kotlin.services.sagemaker.model.ModelDataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelInput] inside the given [block]
         */
        public fun modelInput(block: aws.sdk.kotlin.services.sagemaker.model.ModelInput.Builder.() -> kotlin.Unit) {
            this.modelInput = aws.sdk.kotlin.services.sagemaker.model.ModelInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
