// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
 */
public class ModelDeployConfig private constructor(builder: Builder) {
    /**
     * Set to `True` to automatically generate an endpoint name for a one-click Autopilot model deployment; set to `False` otherwise. The default value is `False`.
     *
     * If you set `AutoGenerateEndpointName` to `True`, do not specify the `EndpointName`; otherwise a 400 error is thrown.
     */
    public val autoGenerateEndpointName: kotlin.Boolean? = builder.autoGenerateEndpointName
    /**
     * Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.
     *
     * Specify the `EndpointName` if and only if you set `AutoGenerateEndpointName` to `False`; otherwise a 400 error is thrown.
     */
    public val endpointName: kotlin.String? = builder.endpointName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelDeployConfig(")
        append("autoGenerateEndpointName=$autoGenerateEndpointName,")
        append("endpointName=$endpointName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoGenerateEndpointName?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelDeployConfig

        if (autoGenerateEndpointName != other.autoGenerateEndpointName) return false
        if (endpointName != other.endpointName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set to `True` to automatically generate an endpoint name for a one-click Autopilot model deployment; set to `False` otherwise. The default value is `False`.
         *
         * If you set `AutoGenerateEndpointName` to `True`, do not specify the `EndpointName`; otherwise a 400 error is thrown.
         */
        public var autoGenerateEndpointName: kotlin.Boolean? = null
        /**
         * Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.
         *
         * Specify the `EndpointName` if and only if you set `AutoGenerateEndpointName` to `False`; otherwise a 400 error is thrown.
         */
        public var endpointName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig) : this() {
            this.autoGenerateEndpointName = x.autoGenerateEndpointName
            this.endpointName = x.endpointName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig = ModelDeployConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
