// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for the JupyterLab application.
 */
public class JupyterLabAppSettings private constructor(builder: Builder) {
    /**
     * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
     */
    public val codeRepositories: List<CodeRepository>? = builder.codeRepositories
    /**
     * A list of custom SageMaker images that are configured to run as a JupyterLab app.
     */
    public val customImages: List<CustomImage>? = builder.customImages
    /**
     * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
     */
    public val defaultResourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = builder.defaultResourceSpec
    /**
     * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To remove a lifecycle config, you must set `LifecycleConfigArns` to an empty list.
     */
    public val lifecycleConfigArns: List<String>? = builder.lifecycleConfigArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JupyterLabAppSettings(")
        append("codeRepositories=$codeRepositories,")
        append("customImages=$customImages,")
        append("defaultResourceSpec=$defaultResourceSpec,")
        append("lifecycleConfigArns=$lifecycleConfigArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeRepositories?.hashCode() ?: 0
        result = 31 * result + (customImages?.hashCode() ?: 0)
        result = 31 * result + (defaultResourceSpec?.hashCode() ?: 0)
        result = 31 * result + (lifecycleConfigArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JupyterLabAppSettings

        if (codeRepositories != other.codeRepositories) return false
        if (customImages != other.customImages) return false
        if (defaultResourceSpec != other.defaultResourceSpec) return false
        if (lifecycleConfigArns != other.lifecycleConfigArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
         */
        public var codeRepositories: List<CodeRepository>? = null
        /**
         * A list of custom SageMaker images that are configured to run as a JupyterLab app.
         */
        public var customImages: List<CustomImage>? = null
        /**
         * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
         */
        public var defaultResourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = null
        /**
         * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To remove a lifecycle config, you must set `LifecycleConfigArns` to an empty list.
         */
        public var lifecycleConfigArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings) : this() {
            this.codeRepositories = x.codeRepositories
            this.customImages = x.customImages
            this.defaultResourceSpec = x.defaultResourceSpec
            this.lifecycleConfigArns = x.lifecycleConfigArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings = JupyterLabAppSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceSpec] inside the given [block]
         */
        public fun defaultResourceSpec(block: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.Builder.() -> kotlin.Unit) {
            this.defaultResourceSpec = aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
