// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use this parameter to specify a supported global condition key that is added to the IAM policy.
 */
public class IamPolicyConstraints private constructor(builder: Builder) {
    /**
     * When `SourceIp` is `Enabled` the worker's IP address when a task is rendered in the worker portal is added to the IAM policy as a `Condition` used to generate the Amazon S3 presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be rendered in the worker portal.
     */
    public val sourceIp: aws.sdk.kotlin.services.sagemaker.model.EnabledOrDisabled? = builder.sourceIp
    /**
     * When `VpcSourceIp` is `Enabled` the worker's IP address when a task is rendered in private worker portal inside the VPC is added to the IAM policy as a `Condition` used to generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM policy. To learn more about configuring private worker portal, see [Use Amazon VPC mode from a private worker portal](https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html).
     */
    public val vpcSourceIp: aws.sdk.kotlin.services.sagemaker.model.EnabledOrDisabled? = builder.vpcSourceIp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.IamPolicyConstraints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IamPolicyConstraints(")
        append("sourceIp=$sourceIp,")
        append("vpcSourceIp=$vpcSourceIp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceIp?.hashCode() ?: 0
        result = 31 * result + (vpcSourceIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IamPolicyConstraints

        if (sourceIp != other.sourceIp) return false
        if (vpcSourceIp != other.vpcSourceIp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.IamPolicyConstraints = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When `SourceIp` is `Enabled` the worker's IP address when a task is rendered in the worker portal is added to the IAM policy as a `Condition` used to generate the Amazon S3 presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be rendered in the worker portal.
         */
        public var sourceIp: aws.sdk.kotlin.services.sagemaker.model.EnabledOrDisabled? = null
        /**
         * When `VpcSourceIp` is `Enabled` the worker's IP address when a task is rendered in private worker portal inside the VPC is added to the IAM policy as a `Condition` used to generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM policy. To learn more about configuring private worker portal, see [Use Amazon VPC mode from a private worker portal](https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html).
         */
        public var vpcSourceIp: aws.sdk.kotlin.services.sagemaker.model.EnabledOrDisabled? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.IamPolicyConstraints) : this() {
            this.sourceIp = x.sourceIp
            this.vpcSourceIp = x.vpcSourceIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.IamPolicyConstraints = IamPolicyConstraints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
