// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input object for the endpoint
 */
public class EndpointInput private constructor(builder: Builder) {
    /**
     * If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html).
     */
    public val endTimeOffset: kotlin.String? = builder.endTimeOffset
    /**
     * An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The attributes of the input data to exclude from the analysis.
     */
    public val excludeFeaturesAttribute: kotlin.String? = builder.excludeFeaturesAttribute
    /**
     * The attributes of the input data that are the input features.
     */
    public val featuresAttribute: kotlin.String? = builder.featuresAttribute
    /**
     * The attribute of the input data that represents the ground truth label.
     */
    public val inferenceAttribute: kotlin.String? = builder.inferenceAttribute
    /**
     * Path to the filesystem where the endpoint data is available to the container.
     */
    public val localPath: kotlin.String? = builder.localPath
    /**
     * In a classification problem, the attribute that represents the class probability.
     */
    public val probabilityAttribute: kotlin.String? = builder.probabilityAttribute
    /**
     * The threshold for the class probability to be evaluated as a positive result.
     */
    public val probabilityThresholdAttribute: kotlin.Double? = builder.probabilityThresholdAttribute
    /**
     * Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key. Defaults to `FullyReplicated`
     */
    public val s3DataDistributionType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3DataDistributionType? = builder.s3DataDistributionType
    /**
     * Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.
     */
    public val s3InputMode: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3InputMode? = builder.s3InputMode
    /**
     * If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html).
     */
    public val startTimeOffset: kotlin.String? = builder.startTimeOffset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EndpointInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointInput(")
        append("endTimeOffset=$endTimeOffset,")
        append("endpointName=$endpointName,")
        append("excludeFeaturesAttribute=$excludeFeaturesAttribute,")
        append("featuresAttribute=$featuresAttribute,")
        append("inferenceAttribute=$inferenceAttribute,")
        append("localPath=$localPath,")
        append("probabilityAttribute=$probabilityAttribute,")
        append("probabilityThresholdAttribute=$probabilityThresholdAttribute,")
        append("s3DataDistributionType=$s3DataDistributionType,")
        append("s3InputMode=$s3InputMode,")
        append("startTimeOffset=$startTimeOffset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTimeOffset?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (excludeFeaturesAttribute?.hashCode() ?: 0)
        result = 31 * result + (featuresAttribute?.hashCode() ?: 0)
        result = 31 * result + (inferenceAttribute?.hashCode() ?: 0)
        result = 31 * result + (localPath?.hashCode() ?: 0)
        result = 31 * result + (probabilityAttribute?.hashCode() ?: 0)
        result = 31 * result + (probabilityThresholdAttribute?.hashCode() ?: 0)
        result = 31 * result + (s3DataDistributionType?.hashCode() ?: 0)
        result = 31 * result + (s3InputMode?.hashCode() ?: 0)
        result = 31 * result + (startTimeOffset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointInput

        if (endTimeOffset != other.endTimeOffset) return false
        if (endpointName != other.endpointName) return false
        if (excludeFeaturesAttribute != other.excludeFeaturesAttribute) return false
        if (featuresAttribute != other.featuresAttribute) return false
        if (inferenceAttribute != other.inferenceAttribute) return false
        if (localPath != other.localPath) return false
        if (probabilityAttribute != other.probabilityAttribute) return false
        if (probabilityThresholdAttribute != other.probabilityThresholdAttribute) return false
        if (s3DataDistributionType != other.s3DataDistributionType) return false
        if (s3InputMode != other.s3InputMode) return false
        if (startTimeOffset != other.startTimeOffset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EndpointInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html).
         */
        public var endTimeOffset: kotlin.String? = null
        /**
         * An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The attributes of the input data to exclude from the analysis.
         */
        public var excludeFeaturesAttribute: kotlin.String? = null
        /**
         * The attributes of the input data that are the input features.
         */
        public var featuresAttribute: kotlin.String? = null
        /**
         * The attribute of the input data that represents the ground truth label.
         */
        public var inferenceAttribute: kotlin.String? = null
        /**
         * Path to the filesystem where the endpoint data is available to the container.
         */
        public var localPath: kotlin.String? = null
        /**
         * In a classification problem, the attribute that represents the class probability.
         */
        public var probabilityAttribute: kotlin.String? = null
        /**
         * The threshold for the class probability to be evaluated as a positive result.
         */
        public var probabilityThresholdAttribute: kotlin.Double? = null
        /**
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key. Defaults to `FullyReplicated`
         */
        public var s3DataDistributionType: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3DataDistributionType? = null
        /**
         * Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.
         */
        public var s3InputMode: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3InputMode? = null
        /**
         * If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html).
         */
        public var startTimeOffset: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EndpointInput) : this() {
            this.endTimeOffset = x.endTimeOffset
            this.endpointName = x.endpointName
            this.excludeFeaturesAttribute = x.excludeFeaturesAttribute
            this.featuresAttribute = x.featuresAttribute
            this.inferenceAttribute = x.inferenceAttribute
            this.localPath = x.localPath
            this.probabilityAttribute = x.probabilityAttribute
            this.probabilityThresholdAttribute = x.probabilityThresholdAttribute
            this.s3DataDistributionType = x.s3DataDistributionType
            this.s3InputMode = x.s3InputMode
            this.startTimeOffset = x.startTimeOffset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EndpointInput = EndpointInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
