// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeEndpointConfigResponse private constructor(builder: Builder) {
    /**
     * Returns the description of an endpoint configuration created using the `CreateEndpointConfig`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html) API.
     */
    public val asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = builder.asyncInferenceConfig
    /**
     * A timestamp that shows when the endpoint configuration was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Configuration to control how SageMaker captures inference data.
     */
    public val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig? = builder.dataCaptureConfig
    /**
     * Indicates whether all model containers deployed to the endpoint are isolated. If they are, no inbound or outbound network calls can be made to or from the model containers.
     */
    public val enableNetworkIsolation: kotlin.Boolean? = builder.enableNetworkIsolation
    /**
     * The Amazon Resource Name (ARN) of the endpoint configuration.
     */
    public val endpointConfigArn: kotlin.String? = builder.endpointConfigArn
    /**
     * Name of the SageMaker endpoint configuration.
     */
    public val endpointConfigName: kotlin.String? = builder.endpointConfigName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that you assigned to the endpoint configuration.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The configuration parameters for an explainer.
     */
    public val explainerConfig: aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig? = builder.explainerConfig
    /**
     * Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
     */
    public val productionVariants: List<ProductionVariant>? = builder.productionVariants
    /**
     * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on `ProductionVariants`.
     */
    public val shadowProductionVariants: List<ProductionVariant>? = builder.shadowProductionVariants
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEndpointConfigResponse(")
        append("asyncInferenceConfig=$asyncInferenceConfig,")
        append("creationTime=$creationTime,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("endpointConfigArn=$endpointConfigArn,")
        append("endpointConfigName=$endpointConfigName,")
        append("executionRoleArn=$executionRoleArn,")
        append("explainerConfig=$explainerConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("productionVariants=$productionVariants,")
        append("shadowProductionVariants=$shadowProductionVariants,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = asyncInferenceConfig?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (enableNetworkIsolation?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigArn?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigName?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (explainerConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (productionVariants?.hashCode() ?: 0)
        result = 31 * result + (shadowProductionVariants?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEndpointConfigResponse

        if (asyncInferenceConfig != other.asyncInferenceConfig) return false
        if (creationTime != other.creationTime) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (endpointConfigArn != other.endpointConfigArn) return false
        if (endpointConfigName != other.endpointConfigName) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (explainerConfig != other.explainerConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (productionVariants != other.productionVariants) return false
        if (shadowProductionVariants != other.shadowProductionVariants) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns the description of an endpoint configuration created using the `CreateEndpointConfig`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html) API.
         */
        public var asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = null
        /**
         * A timestamp that shows when the endpoint configuration was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configuration to control how SageMaker captures inference data.
         */
        public var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig? = null
        /**
         * Indicates whether all model containers deployed to the endpoint are isolated. If they are, no inbound or outbound network calls can be made to or from the model containers.
         */
        public var enableNetworkIsolation: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint configuration.
         */
        public var endpointConfigArn: kotlin.String? = null
        /**
         * Name of the SageMaker endpoint configuration.
         */
        public var endpointConfigName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that you assigned to the endpoint configuration.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The configuration parameters for an explainer.
         */
        public var explainerConfig: aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig? = null
        /**
         * Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
         */
        public var productionVariants: List<ProductionVariant>? = null
        /**
         * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on `ProductionVariants`.
         */
        public var shadowProductionVariants: List<ProductionVariant>? = null
        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse) : this() {
            this.asyncInferenceConfig = x.asyncInferenceConfig
            this.creationTime = x.creationTime
            this.dataCaptureConfig = x.dataCaptureConfig
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.endpointConfigArn = x.endpointConfigArn
            this.endpointConfigName = x.endpointConfigName
            this.executionRoleArn = x.executionRoleArn
            this.explainerConfig = x.explainerConfig
            this.kmsKeyId = x.kmsKeyId
            this.productionVariants = x.productionVariants
            this.shadowProductionVariants = x.shadowProductionVariants
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse = DescribeEndpointConfigResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig] inside the given [block]
         */
        public fun asyncInferenceConfig(block: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.Builder.() -> kotlin.Unit) {
            this.asyncInferenceConfig = aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig] inside the given [block]
         */
        public fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig] inside the given [block]
         */
        public fun explainerConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig.Builder.() -> kotlin.Unit) {
            this.explainerConfig = aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
