// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWorkteamRequest private constructor(builder: Builder) {
    /**
     * A description of the work team.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
     *
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `CognitoMemberDefinition`. For workforces created using your own OIDC identity provider (IdP) use `OidcMemberDefinition`. Do not provide input for both of these parameters in a single request.
     *
     * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito *user groups* within the user pool used to create a workforce. All of the `CognitoMemberDefinition` objects that make up the member definition must have the same `ClientId` and `UserPool` values. To add a Amazon Cognito user group to an existing worker pool, see Adding groups to a User Pool. For more information about user pools, see [Amazon Cognito User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
     *
     * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in `OidcMemberDefinition` by listing those groups in `Groups`.
     */
    public val memberDefinitions: List<MemberDefinition>? = builder.memberDefinitions
    /**
     * Configures notification of workers regarding available or expiring work items.
     */
    public val notificationConfiguration: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * An array of key-value pairs.
     *
     * For more information, see [Resource Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) and [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what) in the * Amazon Web Services Billing and Cost Management User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL.
     */
    public val workerAccessConfiguration: aws.sdk.kotlin.services.sagemaker.model.WorkerAccessConfiguration? = builder.workerAccessConfiguration
    /**
     * The name of the workforce.
     */
    public val workforceName: kotlin.String? = builder.workforceName
    /**
     * The name of the work team. Use this name to identify the work team.
     */
    public val workteamName: kotlin.String? = builder.workteamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateWorkteamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkteamRequest(")
        append("description=$description,")
        append("memberDefinitions=$memberDefinitions,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("tags=$tags,")
        append("workerAccessConfiguration=$workerAccessConfiguration,")
        append("workforceName=$workforceName,")
        append("workteamName=$workteamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (memberDefinitions?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workerAccessConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workforceName?.hashCode() ?: 0)
        result = 31 * result + (workteamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkteamRequest

        if (description != other.description) return false
        if (memberDefinitions != other.memberDefinitions) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (tags != other.tags) return false
        if (workerAccessConfiguration != other.workerAccessConfiguration) return false
        if (workforceName != other.workforceName) return false
        if (workteamName != other.workteamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateWorkteamRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the work team.
         */
        public var description: kotlin.String? = null
        /**
         * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
         *
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `CognitoMemberDefinition`. For workforces created using your own OIDC identity provider (IdP) use `OidcMemberDefinition`. Do not provide input for both of these parameters in a single request.
         *
         * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito *user groups* within the user pool used to create a workforce. All of the `CognitoMemberDefinition` objects that make up the member definition must have the same `ClientId` and `UserPool` values. To add a Amazon Cognito user group to an existing worker pool, see Adding groups to a User Pool. For more information about user pools, see [Amazon Cognito User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
         *
         * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in `OidcMemberDefinition` by listing those groups in `Groups`.
         */
        public var memberDefinitions: List<MemberDefinition>? = null
        /**
         * Configures notification of workers regarding available or expiring work items.
         */
        public var notificationConfiguration: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration? = null
        /**
         * An array of key-value pairs.
         *
         * For more information, see [Resource Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) and [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what) in the * Amazon Web Services Billing and Cost Management User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL.
         */
        public var workerAccessConfiguration: aws.sdk.kotlin.services.sagemaker.model.WorkerAccessConfiguration? = null
        /**
         * The name of the workforce.
         */
        public var workforceName: kotlin.String? = null
        /**
         * The name of the work team. Use this name to identify the work team.
         */
        public var workteamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateWorkteamRequest) : this() {
            this.description = x.description
            this.memberDefinitions = x.memberDefinitions
            this.notificationConfiguration = x.notificationConfiguration
            this.tags = x.tags
            this.workerAccessConfiguration = x.workerAccessConfiguration
            this.workforceName = x.workforceName
            this.workteamName = x.workteamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateWorkteamRequest = CreateWorkteamRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration] inside the given [block]
         */
        public fun notificationConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.WorkerAccessConfiguration] inside the given [block]
         */
        public fun workerAccessConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.WorkerAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.workerAccessConfiguration = aws.sdk.kotlin.services.sagemaker.model.WorkerAccessConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
