// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Stores the configuration information for how model candidates are generated using an AutoML job V2.
 */
public class CandidateGenerationConfig private constructor(builder: Builder) {
    /**
     * Stores the configuration information for the selection of algorithms used to train model candidates on tabular data.
     *
     * The list of available algorithms to choose from depends on the training mode set in `TabularJobConfig.Mode`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TabularJobConfig.html).
     * + `AlgorithmsConfig` should not be set in `AUTO` training mode.
     * + When `AlgorithmsConfig` is provided, one `AutoMLAlgorithms` attribute must be set and one only.If the list of algorithms provided as values for `AutoMLAlgorithms` is empty, `CandidateGenerationConfig` uses the full set of algorithms for the given training mode.
     * + When `AlgorithmsConfig` is not provided, `CandidateGenerationConfig` uses the full set of algorithms for the given training mode.
     *
     * For the list of all algorithms per problem type and training mode, see [ AutoMLAlgorithmConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html).
     *
     * For more information on each algorithm, see the [Algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) section in Autopilot developer guide.
     */
    public val algorithmsConfig: List<AutoMlAlgorithmConfig>? = builder.algorithmsConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CandidateGenerationConfig(")
        append("algorithmsConfig=$algorithmsConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmsConfig?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CandidateGenerationConfig

        if (algorithmsConfig != other.algorithmsConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Stores the configuration information for the selection of algorithms used to train model candidates on tabular data.
         *
         * The list of available algorithms to choose from depends on the training mode set in `TabularJobConfig.Mode`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TabularJobConfig.html).
         * + `AlgorithmsConfig` should not be set in `AUTO` training mode.
         * + When `AlgorithmsConfig` is provided, one `AutoMLAlgorithms` attribute must be set and one only.If the list of algorithms provided as values for `AutoMLAlgorithms` is empty, `CandidateGenerationConfig` uses the full set of algorithms for the given training mode.
         * + When `AlgorithmsConfig` is not provided, `CandidateGenerationConfig` uses the full set of algorithms for the given training mode.
         *
         * For the list of all algorithms per problem type and training mode, see [ AutoMLAlgorithmConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html).
         *
         * For more information on each algorithm, see the [Algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) section in Autopilot developer guide.
         */
        public var algorithmsConfig: List<AutoMlAlgorithmConfig>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig) : this() {
            this.algorithmsConfig = x.algorithmsConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig = CandidateGenerationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
