// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists the properties of an *action*. An action represents an action or activity. Some examples are a workflow step and a model deployment. Generally, an action involves at least one input artifact or output artifact.
 */
public class ActionSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the action.
     */
    public val actionArn: kotlin.String? = builder.actionArn
    /**
     * The name of the action.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * The type of the action.
     */
    public val actionType: kotlin.String? = builder.actionType
    /**
     * When the action was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * When the action was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The source of the action.
     */
    public val source: aws.sdk.kotlin.services.sagemaker.model.ActionSource? = builder.source
    /**
     * The status of the action.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.ActionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ActionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionSummary(")
        append("actionArn=$actionArn,")
        append("actionName=$actionName,")
        append("actionType=$actionType,")
        append("creationTime=$creationTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("source=$source,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionArn?.hashCode() ?: 0
        result = 31 * result + (actionName?.hashCode() ?: 0)
        result = 31 * result + (actionType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionSummary

        if (actionArn != other.actionArn) return false
        if (actionName != other.actionName) return false
        if (actionType != other.actionType) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (source != other.source) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ActionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the action.
         */
        public var actionArn: kotlin.String? = null
        /**
         * The name of the action.
         */
        public var actionName: kotlin.String? = null
        /**
         * The type of the action.
         */
        public var actionType: kotlin.String? = null
        /**
         * When the action was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When the action was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The source of the action.
         */
        public var source: aws.sdk.kotlin.services.sagemaker.model.ActionSource? = null
        /**
         * The status of the action.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.ActionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ActionSummary) : this() {
            this.actionArn = x.actionArn
            this.actionName = x.actionName
            this.actionType = x.actionType
            this.creationTime = x.creationTime
            this.lastModifiedTime = x.lastModifiedTime
            this.source = x.source
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ActionSummary = ActionSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ActionSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.sagemaker.model.ActionSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.sagemaker.model.ActionSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
