// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.Edge
import aws.sdk.kotlin.services.sagemaker.model.QueryLineageResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.Vertex
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class QueryLineageOperationDeserializer: HttpDeserialize<QueryLineageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): QueryLineageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwQueryLineageError(context, call)
        }
        val builder = QueryLineageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeQueryLineageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwQueryLineageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeQueryLineageOperationBody(builder: QueryLineageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EDGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Edges"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val VERTICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Vertices"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EDGES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(VERTICES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EDGES_DESCRIPTOR.index -> builder.edges =
                    deserializer.deserializeList(EDGES_DESCRIPTOR) {
                        val col0 = mutableListOf<Edge>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEdgeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                VERTICES_DESCRIPTOR.index -> builder.vertices =
                    deserializer.deserializeList(VERTICES_DESCRIPTOR) {
                        val col0 = mutableListOf<Vertex>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVertexDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
