// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeTrialResponse
import aws.sdk.kotlin.services.sagemaker.model.MetadataProperties
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrialSource
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeTrialOperationDeserializer: HttpDeserialize<DescribeTrialResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeTrialResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTrialError(context, call)
        }
        val builder = DescribeTrialResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTrialOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeTrialError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrialOperationBody(builder: DescribeTrialResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val EXPERIMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExperimentName"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val METADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetadataProperties"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Source"))
    val TRIALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrialArn"))
    val TRIALNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrialName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(EXPERIMENTNAME_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(METADATAPROPERTIES_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(TRIALARN_DESCRIPTOR)
        field(TRIALNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                EXPERIMENTNAME_DESCRIPTOR.index -> builder.experimentName = deserializeString()
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                METADATAPROPERTIES_DESCRIPTOR.index -> builder.metadataProperties = deserializeMetadataPropertiesDocument(deserializer)
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeTrialSourceDocument(deserializer)
                TRIALARN_DESCRIPTOR.index -> builder.trialArn = deserializeString()
                TRIALNAME_DESCRIPTOR.index -> builder.trialName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
