// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeTrialComponentResponse
import aws.sdk.kotlin.services.sagemaker.model.MetadataProperties
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrialComponentArtifact
import aws.sdk.kotlin.services.sagemaker.model.TrialComponentMetricSummary
import aws.sdk.kotlin.services.sagemaker.model.TrialComponentParameterValue
import aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource
import aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeTrialComponentOperationDeserializer: HttpDeserialize<DescribeTrialComponentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeTrialComponentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTrialComponentError(context, call)
        }
        val builder = DescribeTrialComponentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTrialComponentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeTrialComponentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrialComponentOperationBody(builder: DescribeTrialComponentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val INPUTARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("InputArtifacts"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LINEAGEGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LineageGroupArn"))
    val METADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetadataProperties"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Metrics"))
    val OUTPUTARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("OutputArtifacts"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Parameters"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Source"))
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Sources"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Status"))
    val TRIALCOMPONENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrialComponentArn"))
    val TRIALCOMPONENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrialComponentName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(INPUTARTIFACTS_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LINEAGEGROUPARN_DESCRIPTOR)
        field(METADATAPROPERTIES_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(OUTPUTARTIFACTS_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(SOURCES_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRIALCOMPONENTARN_DESCRIPTOR)
        field(TRIALCOMPONENTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                INPUTARTIFACTS_DESCRIPTOR.index -> builder.inputArtifacts =
                    deserializer.deserializeMap(INPUTARTIFACTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, TrialComponentArtifact>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeTrialComponentArtifactDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LINEAGEGROUPARN_DESCRIPTOR.index -> builder.lineageGroupArn = deserializeString()
                METADATAPROPERTIES_DESCRIPTOR.index -> builder.metadataProperties = deserializeMetadataPropertiesDocument(deserializer)
                METRICS_DESCRIPTOR.index -> builder.metrics =
                    deserializer.deserializeList(METRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<TrialComponentMetricSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTrialComponentMetricSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OUTPUTARTIFACTS_DESCRIPTOR.index -> builder.outputArtifacts =
                    deserializer.deserializeMap(OUTPUTARTIFACTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, TrialComponentArtifact>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeTrialComponentArtifactDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                PARAMETERS_DESCRIPTOR.index -> builder.parameters =
                    deserializer.deserializeMap(PARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, TrialComponentParameterValue>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeTrialComponentParameterValueDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeTrialComponentSourceDocument(deserializer)
                SOURCES_DESCRIPTOR.index -> builder.sources =
                    deserializer.deserializeList(SOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<TrialComponentSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTrialComponentSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeTrialComponentStatusDocument(deserializer)
                TRIALCOMPONENTARN_DESCRIPTOR.index -> builder.trialComponentArn = deserializeString()
                TRIALCOMPONENTNAME_DESCRIPTOR.index -> builder.trialComponentName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
