// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribePipelineResponse
import aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration
import aws.sdk.kotlin.services.sagemaker.model.PipelineStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribePipelineOperationDeserializer: HttpDeserialize<DescribePipelineResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribePipelineResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePipelineError(context, call)
        }
        val builder = DescribePipelineResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePipelineOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribePipelineError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePipelineOperationBody(builder: DescribePipelineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LASTRUNTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastRunTime"))
    val PARALLELISMCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ParallelismConfiguration"))
    val PIPELINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineArn"))
    val PIPELINEDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineDefinition"))
    val PIPELINEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineDescription"))
    val PIPELINEDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineDisplayName"))
    val PIPELINENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineName"))
    val PIPELINESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PipelineStatus"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LASTRUNTIME_DESCRIPTOR)
        field(PARALLELISMCONFIGURATION_DESCRIPTOR)
        field(PIPELINEARN_DESCRIPTOR)
        field(PIPELINEDEFINITION_DESCRIPTOR)
        field(PIPELINEDESCRIPTION_DESCRIPTOR)
        field(PIPELINEDISPLAYNAME_DESCRIPTOR)
        field(PIPELINENAME_DESCRIPTOR)
        field(PIPELINESTATUS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTRUNTIME_DESCRIPTOR.index -> builder.lastRunTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                PARALLELISMCONFIGURATION_DESCRIPTOR.index -> builder.parallelismConfiguration = deserializeParallelismConfigurationDocument(deserializer)
                PIPELINEARN_DESCRIPTOR.index -> builder.pipelineArn = deserializeString()
                PIPELINEDEFINITION_DESCRIPTOR.index -> builder.pipelineDefinition = deserializeString()
                PIPELINEDESCRIPTION_DESCRIPTOR.index -> builder.pipelineDescription = deserializeString()
                PIPELINEDISPLAYNAME_DESCRIPTOR.index -> builder.pipelineDisplayName = deserializeString()
                PIPELINENAME_DESCRIPTOR.index -> builder.pipelineName = deserializeString()
                PIPELINESTATUS_DESCRIPTOR.index -> builder.pipelineStatus = deserializeString().let { PipelineStatus.fromValue(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
