// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AdditionalInferenceSpecificationDefinition
import aws.sdk.kotlin.services.sagemaker.model.DescribeModelPackageResponse
import aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines
import aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification
import aws.sdk.kotlin.services.sagemaker.model.MetadataProperties
import aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus
import aws.sdk.kotlin.services.sagemaker.model.ModelMetrics
import aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus
import aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails
import aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.SkipModelValidation
import aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeModelPackageOperationDeserializer: HttpDeserialize<DescribeModelPackageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeModelPackageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelPackageError(context, call)
        }
        val builder = DescribeModelPackageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeModelPackageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeModelPackageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelPackageOperationBody(builder: DescribeModelPackageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDITIONALINFERENCESPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdditionalInferenceSpecifications"))
    val APPROVALDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApprovalDescription"))
    val CERTIFYFORMARKETPLACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CertifyForMarketplace"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val CUSTOMERMETADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("CustomerMetadataProperties"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Domain"))
    val DRIFTCHECKBASELINES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DriftCheckBaselines"))
    val INFERENCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InferenceSpecification"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val METADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetadataProperties"))
    val MODELAPPROVALSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ModelApprovalStatus"))
    val MODELMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelMetrics"))
    val MODELPACKAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageArn"))
    val MODELPACKAGEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageDescription"))
    val MODELPACKAGEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageGroupName"))
    val MODELPACKAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageName"))
    val MODELPACKAGESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ModelPackageStatus"))
    val MODELPACKAGESTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelPackageStatusDetails"))
    val MODELPACKAGEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ModelPackageVersion"))
    val SAMPLEPAYLOADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SamplePayloadUrl"))
    val SKIPMODELVALIDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SkipModelValidation"))
    val SOURCEALGORITHMSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceAlgorithmSpecification"))
    val TASK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Task"))
    val VALIDATIONSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALINFERENCESPECIFICATIONS_DESCRIPTOR)
        field(APPROVALDESCRIPTION_DESCRIPTOR)
        field(CERTIFYFORMARKETPLACE_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(CUSTOMERMETADATAPROPERTIES_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(DRIFTCHECKBASELINES_DESCRIPTOR)
        field(INFERENCESPECIFICATION_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(METADATAPROPERTIES_DESCRIPTOR)
        field(MODELAPPROVALSTATUS_DESCRIPTOR)
        field(MODELMETRICS_DESCRIPTOR)
        field(MODELPACKAGEARN_DESCRIPTOR)
        field(MODELPACKAGEDESCRIPTION_DESCRIPTOR)
        field(MODELPACKAGEGROUPNAME_DESCRIPTOR)
        field(MODELPACKAGENAME_DESCRIPTOR)
        field(MODELPACKAGESTATUS_DESCRIPTOR)
        field(MODELPACKAGESTATUSDETAILS_DESCRIPTOR)
        field(MODELPACKAGEVERSION_DESCRIPTOR)
        field(SAMPLEPAYLOADURL_DESCRIPTOR)
        field(SKIPMODELVALIDATION_DESCRIPTOR)
        field(SOURCEALGORITHMSPECIFICATION_DESCRIPTOR)
        field(TASK_DESCRIPTOR)
        field(VALIDATIONSPECIFICATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDITIONALINFERENCESPECIFICATIONS_DESCRIPTOR.index -> builder.additionalInferenceSpecifications =
                    deserializer.deserializeList(ADDITIONALINFERENCESPECIFICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdditionalInferenceSpecificationDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdditionalInferenceSpecificationDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                APPROVALDESCRIPTION_DESCRIPTOR.index -> builder.approvalDescription = deserializeString()
                CERTIFYFORMARKETPLACE_DESCRIPTOR.index -> builder.certifyForMarketplace = deserializeBoolean()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CUSTOMERMETADATAPROPERTIES_DESCRIPTOR.index -> builder.customerMetadataProperties =
                    deserializer.deserializeMap(CUSTOMERMETADATAPROPERTIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString()
                DRIFTCHECKBASELINES_DESCRIPTOR.index -> builder.driftCheckBaselines = deserializeDriftCheckBaselinesDocument(deserializer)
                INFERENCESPECIFICATION_DESCRIPTOR.index -> builder.inferenceSpecification = deserializeInferenceSpecificationDocument(deserializer)
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                METADATAPROPERTIES_DESCRIPTOR.index -> builder.metadataProperties = deserializeMetadataPropertiesDocument(deserializer)
                MODELAPPROVALSTATUS_DESCRIPTOR.index -> builder.modelApprovalStatus = deserializeString().let { ModelApprovalStatus.fromValue(it) }
                MODELMETRICS_DESCRIPTOR.index -> builder.modelMetrics = deserializeModelMetricsDocument(deserializer)
                MODELPACKAGEARN_DESCRIPTOR.index -> builder.modelPackageArn = deserializeString()
                MODELPACKAGEDESCRIPTION_DESCRIPTOR.index -> builder.modelPackageDescription = deserializeString()
                MODELPACKAGEGROUPNAME_DESCRIPTOR.index -> builder.modelPackageGroupName = deserializeString()
                MODELPACKAGENAME_DESCRIPTOR.index -> builder.modelPackageName = deserializeString()
                MODELPACKAGESTATUS_DESCRIPTOR.index -> builder.modelPackageStatus = deserializeString().let { ModelPackageStatus.fromValue(it) }
                MODELPACKAGESTATUSDETAILS_DESCRIPTOR.index -> builder.modelPackageStatusDetails = deserializeModelPackageStatusDetailsDocument(deserializer)
                MODELPACKAGEVERSION_DESCRIPTOR.index -> builder.modelPackageVersion = deserializeInt()
                SAMPLEPAYLOADURL_DESCRIPTOR.index -> builder.samplePayloadUrl = deserializeString()
                SKIPMODELVALIDATION_DESCRIPTOR.index -> builder.skipModelValidation = deserializeString().let { SkipModelValidation.fromValue(it) }
                SOURCEALGORITHMSPECIFICATION_DESCRIPTOR.index -> builder.sourceAlgorithmSpecification = deserializeSourceAlgorithmSpecificationDocument(deserializer)
                TASK_DESCRIPTOR.index -> builder.task = deserializeString()
                VALIDATIONSPECIFICATION_DESCRIPTOR.index -> builder.validationSpecification = deserializeModelPackageValidationSpecificationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
