// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceExperimentResponse
import aws.sdk.kotlin.services.sagemaker.model.EndpointMetadata
import aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig
import aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule
import aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentStatus
import aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType
import aws.sdk.kotlin.services.sagemaker.model.ModelVariantConfigSummary
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeInferenceExperimentOperationDeserializer: HttpDeserialize<DescribeInferenceExperimentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeInferenceExperimentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeInferenceExperimentError(context, call)
        }
        val builder = DescribeInferenceExperimentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInferenceExperimentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeInferenceExperimentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInferenceExperimentOperationBody(builder: DescribeInferenceExperimentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val COMPLETIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionTime"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASTORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataStorageConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDPOINTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointMetadata"))
    val KMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKey"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELVARIANTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ModelVariants"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schedule"))
    val SHADOWMODECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ShadowModeConfig"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusReason"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(COMPLETIONTIME_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASTORAGECONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDPOINTMETADATA_DESCRIPTOR)
        field(KMSKEY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELVARIANTS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SHADOWMODECONFIG_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COMPLETIONTIME_DESCRIPTOR.index -> builder.completionTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATASTORAGECONFIG_DESCRIPTOR.index -> builder.dataStorageConfig = deserializeInferenceExperimentDataStorageConfigDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDPOINTMETADATA_DESCRIPTOR.index -> builder.endpointMetadata = deserializeEndpointMetadataDocument(deserializer)
                KMSKEY_DESCRIPTOR.index -> builder.kmsKey = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELVARIANTS_DESCRIPTOR.index -> builder.modelVariants =
                    deserializer.deserializeList(MODELVARIANTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ModelVariantConfigSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeModelVariantConfigSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeInferenceExperimentScheduleDocument(deserializer)
                SHADOWMODECONFIG_DESCRIPTOR.index -> builder.shadowModeConfig = deserializeShadowModeConfigDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { InferenceExperimentStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { InferenceExperimentType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
