// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig
import aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary
import aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig
import aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse
import aws.sdk.kotlin.services.sagemaker.model.EndpointStatus
import aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig
import aws.sdk.kotlin.services.sagemaker.model.PendingDeploymentSummary
import aws.sdk.kotlin.services.sagemaker.model.ProductionVariantSummary
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeEndpointOperationDeserializer: HttpDeserialize<DescribeEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEndpointError(context, call)
        }
        val builder = DescribeEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEndpointOperationBody(builder: DescribeEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASYNCINFERENCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AsyncInferenceConfig"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATACAPTURECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataCaptureConfig"))
    val ENDPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointArn"))
    val ENDPOINTCONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointConfigName"))
    val ENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointName"))
    val ENDPOINTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("EndpointStatus"))
    val EXPLAINERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExplainerConfig"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTDEPLOYMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastDeploymentConfig"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val PENDINGDEPLOYMENTSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PendingDeploymentSummary"))
    val PRODUCTIONVARIANTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProductionVariants"))
    val SHADOWPRODUCTIONVARIANTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ShadowProductionVariants"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASYNCINFERENCECONFIG_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATACAPTURECONFIG_DESCRIPTOR)
        field(ENDPOINTARN_DESCRIPTOR)
        field(ENDPOINTCONFIGNAME_DESCRIPTOR)
        field(ENDPOINTNAME_DESCRIPTOR)
        field(ENDPOINTSTATUS_DESCRIPTOR)
        field(EXPLAINERCONFIG_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTDEPLOYMENTCONFIG_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(PENDINGDEPLOYMENTSUMMARY_DESCRIPTOR)
        field(PRODUCTIONVARIANTS_DESCRIPTOR)
        field(SHADOWPRODUCTIONVARIANTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASYNCINFERENCECONFIG_DESCRIPTOR.index -> builder.asyncInferenceConfig = deserializeAsyncInferenceConfigDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATACAPTURECONFIG_DESCRIPTOR.index -> builder.dataCaptureConfig = deserializeDataCaptureConfigSummaryDocument(deserializer)
                ENDPOINTARN_DESCRIPTOR.index -> builder.endpointArn = deserializeString()
                ENDPOINTCONFIGNAME_DESCRIPTOR.index -> builder.endpointConfigName = deserializeString()
                ENDPOINTNAME_DESCRIPTOR.index -> builder.endpointName = deserializeString()
                ENDPOINTSTATUS_DESCRIPTOR.index -> builder.endpointStatus = deserializeString().let { EndpointStatus.fromValue(it) }
                EXPLAINERCONFIG_DESCRIPTOR.index -> builder.explainerConfig = deserializeExplainerConfigDocument(deserializer)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTDEPLOYMENTCONFIG_DESCRIPTOR.index -> builder.lastDeploymentConfig = deserializeDeploymentConfigDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                PENDINGDEPLOYMENTSUMMARY_DESCRIPTOR.index -> builder.pendingDeploymentSummary = deserializePendingDeploymentSummaryDocument(deserializer)
                PRODUCTIONVARIANTS_DESCRIPTOR.index -> builder.productionVariants =
                    deserializer.deserializeList(PRODUCTIONVARIANTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductionVariantSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductionVariantSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SHADOWPRODUCTIONVARIANTS_DESCRIPTOR.index -> builder.shadowProductionVariants =
                    deserializer.deserializeList(SHADOWPRODUCTIONVARIANTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductionVariantSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductionVariantSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
