// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig
import aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig
import aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointConfigResponse
import aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig
import aws.sdk.kotlin.services.sagemaker.model.ProductionVariant
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.VpcConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeEndpointConfigOperationDeserializer: HttpDeserialize<DescribeEndpointConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeEndpointConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEndpointConfigError(context, call)
        }
        val builder = DescribeEndpointConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEndpointConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeEndpointConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEndpointConfigOperationBody(builder: DescribeEndpointConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASYNCINFERENCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AsyncInferenceConfig"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATACAPTURECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataCaptureConfig"))
    val ENABLENETWORKISOLATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableNetworkIsolation"))
    val ENDPOINTCONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointConfigArn"))
    val ENDPOINTCONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointConfigName"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val EXPLAINERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExplainerConfig"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val PRODUCTIONVARIANTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProductionVariants"))
    val SHADOWPRODUCTIONVARIANTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ShadowProductionVariants"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASYNCINFERENCECONFIG_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATACAPTURECONFIG_DESCRIPTOR)
        field(ENABLENETWORKISOLATION_DESCRIPTOR)
        field(ENDPOINTCONFIGARN_DESCRIPTOR)
        field(ENDPOINTCONFIGNAME_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(EXPLAINERCONFIG_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(PRODUCTIONVARIANTS_DESCRIPTOR)
        field(SHADOWPRODUCTIONVARIANTS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASYNCINFERENCECONFIG_DESCRIPTOR.index -> builder.asyncInferenceConfig = deserializeAsyncInferenceConfigDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATACAPTURECONFIG_DESCRIPTOR.index -> builder.dataCaptureConfig = deserializeDataCaptureConfigDocument(deserializer)
                ENABLENETWORKISOLATION_DESCRIPTOR.index -> builder.enableNetworkIsolation = deserializeBoolean()
                ENDPOINTCONFIGARN_DESCRIPTOR.index -> builder.endpointConfigArn = deserializeString()
                ENDPOINTCONFIGNAME_DESCRIPTOR.index -> builder.endpointConfigName = deserializeString()
                EXECUTIONROLEARN_DESCRIPTOR.index -> builder.executionRoleArn = deserializeString()
                EXPLAINERCONFIG_DESCRIPTOR.index -> builder.explainerConfig = deserializeExplainerConfigDocument(deserializer)
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                PRODUCTIONVARIANTS_DESCRIPTOR.index -> builder.productionVariants =
                    deserializer.deserializeList(PRODUCTIONVARIANTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductionVariant>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductionVariantDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SHADOWPRODUCTIONVARIANTS_DESCRIPTOR.index -> builder.shadowProductionVariants =
                    deserializer.deserializeList(SHADOWPRODUCTIONVARIANTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductionVariant>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductionVariantDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
