// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.sagemaker.model.EdgeModel
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeDeviceOperationDeserializer: HttpDeserialize<DescribeDeviceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDeviceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDeviceError(context, call)
        }
        val builder = DescribeDeviceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDeviceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDeviceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDeviceOperationBody(builder: DescribeDeviceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AgentVersion"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceArn"))
    val DEVICEFLEETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetName"))
    val DEVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceName"))
    val IOTTHINGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IotThingName"))
    val LATESTHEARTBEAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestHeartbeat"))
    val MAXMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxModels"))
    val MODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Models"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val REGISTRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("RegistrationTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTVERSION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEARN_DESCRIPTOR)
        field(DEVICEFLEETNAME_DESCRIPTOR)
        field(DEVICENAME_DESCRIPTOR)
        field(IOTTHINGNAME_DESCRIPTOR)
        field(LATESTHEARTBEAT_DESCRIPTOR)
        field(MAXMODELS_DESCRIPTOR)
        field(MODELS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REGISTRATIONTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTVERSION_DESCRIPTOR.index -> builder.agentVersion = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DEVICEARN_DESCRIPTOR.index -> builder.deviceArn = deserializeString()
                DEVICEFLEETNAME_DESCRIPTOR.index -> builder.deviceFleetName = deserializeString()
                DEVICENAME_DESCRIPTOR.index -> builder.deviceName = deserializeString()
                IOTTHINGNAME_DESCRIPTOR.index -> builder.iotThingName = deserializeString()
                LATESTHEARTBEAT_DESCRIPTOR.index -> builder.latestHeartbeat = deserializeString().let { Instant.fromEpochSeconds(it) }
                MAXMODELS_DESCRIPTOR.index -> builder.maxModels = deserializeInt()
                MODELS_DESCRIPTOR.index -> builder.models =
                    deserializer.deserializeList(MODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<EdgeModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEdgeModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REGISTRATIONTIME_DESCRIPTOR.index -> builder.registrationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
