// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.CompilationJobStatus
import aws.sdk.kotlin.services.sagemaker.model.DerivedInformation
import aws.sdk.kotlin.services.sagemaker.model.DescribeCompilationJobResponse
import aws.sdk.kotlin.services.sagemaker.model.InputConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts
import aws.sdk.kotlin.services.sagemaker.model.ModelDigests
import aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig
import aws.sdk.kotlin.services.sagemaker.model.OutputConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.StoppingCondition
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeCompilationJobOperationDeserializer: HttpDeserialize<DescribeCompilationJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeCompilationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCompilationJobError(context, call)
        }
        val builder = DescribeCompilationJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCompilationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeCompilationJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCompilationJobOperationBody(builder: DescribeCompilationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPILATIONENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompilationEndTime"))
    val COMPILATIONJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CompilationJobArn"))
    val COMPILATIONJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CompilationJobName"))
    val COMPILATIONJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("CompilationJobStatus"))
    val COMPILATIONSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompilationStartTime"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DERIVEDINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DerivedInformation"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val INFERENCEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InferenceImage"))
    val INPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputConfig"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelArtifacts"))
    val MODELDIGESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelDigests"))
    val MODELPACKAGEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageVersionArn"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPILATIONENDTIME_DESCRIPTOR)
        field(COMPILATIONJOBARN_DESCRIPTOR)
        field(COMPILATIONJOBNAME_DESCRIPTOR)
        field(COMPILATIONJOBSTATUS_DESCRIPTOR)
        field(COMPILATIONSTARTTIME_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DERIVEDINFORMATION_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(INFERENCEIMAGE_DESCRIPTOR)
        field(INPUTCONFIG_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELARTIFACTS_DESCRIPTOR)
        field(MODELDIGESTS_DESCRIPTOR)
        field(MODELPACKAGEVERSIONARN_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPILATIONENDTIME_DESCRIPTOR.index -> builder.compilationEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                COMPILATIONJOBARN_DESCRIPTOR.index -> builder.compilationJobArn = deserializeString()
                COMPILATIONJOBNAME_DESCRIPTOR.index -> builder.compilationJobName = deserializeString()
                COMPILATIONJOBSTATUS_DESCRIPTOR.index -> builder.compilationJobStatus = deserializeString().let { CompilationJobStatus.fromValue(it) }
                COMPILATIONSTARTTIME_DESCRIPTOR.index -> builder.compilationStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DERIVEDINFORMATION_DESCRIPTOR.index -> builder.derivedInformation = deserializeDerivedInformationDocument(deserializer)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                INFERENCEIMAGE_DESCRIPTOR.index -> builder.inferenceImage = deserializeString()
                INPUTCONFIG_DESCRIPTOR.index -> builder.inputConfig = deserializeInputConfigDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELARTIFACTS_DESCRIPTOR.index -> builder.modelArtifacts = deserializeModelArtifactsDocument(deserializer)
                MODELDIGESTS_DESCRIPTOR.index -> builder.modelDigests = deserializeModelDigestsDocument(deserializer)
                MODELPACKAGEVERSIONARN_DESCRIPTOR.index -> builder.modelPackageVersionArn = deserializeString()
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeOutputConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeStoppingConditionDocument(deserializer)
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeNeoVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
