// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidate
import aws.sdk.kotlin.services.sagemaker.model.AutoMlChannel
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobArtifacts
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobSecondaryStatus
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobStatus
import aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig
import aws.sdk.kotlin.services.sagemaker.model.AutoMlPartialFailureReason
import aws.sdk.kotlin.services.sagemaker.model.DescribeAutoMlJobResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelDeployResult
import aws.sdk.kotlin.services.sagemaker.model.ProblemType
import aws.sdk.kotlin.services.sagemaker.model.ResolvedAttributes
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeAutoMLJobOperationDeserializer: HttpDeserialize<DescribeAutoMlJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeAutoMlJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAutoMlJobError(context, call)
        }
        val builder = DescribeAutoMlJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAutoMLJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeAutoMlJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAutoMLJobOperationBody(builder: DescribeAutoMlJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOMLJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoMLJobArn"))
    val AUTOMLJOBARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMLJobArtifacts"))
    val AUTOMLJOBCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMLJobConfig"))
    val AUTOMLJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoMLJobName"))
    val AUTOMLJOBOBJECTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMLJobObjective"))
    val AUTOMLJOBSECONDARYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLJobSecondaryStatus"))
    val AUTOMLJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLJobStatus"))
    val BESTCANDIDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BestCandidate"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val GENERATECANDIDATEDEFINITIONSONLY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("GenerateCandidateDefinitionsOnly"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InputDataConfig"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELDEPLOYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelDeployConfig"))
    val MODELDEPLOYRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelDeployResult"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputDataConfig"))
    val PARTIALFAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PartialFailureReasons"))
    val PROBLEMTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ProblemType"))
    val RESOLVEDATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResolvedAttributes"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOMLJOBARN_DESCRIPTOR)
        field(AUTOMLJOBARTIFACTS_DESCRIPTOR)
        field(AUTOMLJOBCONFIG_DESCRIPTOR)
        field(AUTOMLJOBNAME_DESCRIPTOR)
        field(AUTOMLJOBOBJECTIVE_DESCRIPTOR)
        field(AUTOMLJOBSECONDARYSTATUS_DESCRIPTOR)
        field(AUTOMLJOBSTATUS_DESCRIPTOR)
        field(BESTCANDIDATE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(GENERATECANDIDATEDEFINITIONSONLY_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELDEPLOYCONFIG_DESCRIPTOR)
        field(MODELDEPLOYRESULT_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(PARTIALFAILUREREASONS_DESCRIPTOR)
        field(PROBLEMTYPE_DESCRIPTOR)
        field(RESOLVEDATTRIBUTES_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOMLJOBARN_DESCRIPTOR.index -> builder.autoMlJobArn = deserializeString()
                AUTOMLJOBARTIFACTS_DESCRIPTOR.index -> builder.autoMlJobArtifacts = deserializeAutoMlJobArtifactsDocument(deserializer)
                AUTOMLJOBCONFIG_DESCRIPTOR.index -> builder.autoMlJobConfig = deserializeAutoMlJobConfigDocument(deserializer)
                AUTOMLJOBNAME_DESCRIPTOR.index -> builder.autoMlJobName = deserializeString()
                AUTOMLJOBOBJECTIVE_DESCRIPTOR.index -> builder.autoMlJobObjective = deserializeAutoMlJobObjectiveDocument(deserializer)
                AUTOMLJOBSECONDARYSTATUS_DESCRIPTOR.index -> builder.autoMlJobSecondaryStatus = deserializeString().let { AutoMlJobSecondaryStatus.fromValue(it) }
                AUTOMLJOBSTATUS_DESCRIPTOR.index -> builder.autoMlJobStatus = deserializeString().let { AutoMlJobStatus.fromValue(it) }
                BESTCANDIDATE_DESCRIPTOR.index -> builder.bestCandidate = deserializeAutoMlCandidateDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                GENERATECANDIDATEDEFINITIONSONLY_DESCRIPTOR.index -> builder.generateCandidateDefinitionsOnly = deserializeBoolean()
                INPUTDATACONFIG_DESCRIPTOR.index -> builder.inputDataConfig =
                    deserializer.deserializeList(INPUTDATACONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoMlChannel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoMlChannelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELDEPLOYCONFIG_DESCRIPTOR.index -> builder.modelDeployConfig = deserializeModelDeployConfigDocument(deserializer)
                MODELDEPLOYRESULT_DESCRIPTOR.index -> builder.modelDeployResult = deserializeModelDeployResultDocument(deserializer)
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeAutoMlOutputDataConfigDocument(deserializer)
                PARTIALFAILUREREASONS_DESCRIPTOR.index -> builder.partialFailureReasons =
                    deserializer.deserializeList(PARTIALFAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoMlPartialFailureReason>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoMlPartialFailureReasonDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROBLEMTYPE_DESCRIPTOR.index -> builder.problemType = deserializeString().let { ProblemType.fromValue(it) }
                RESOLVEDATTRIBUTES_DESCRIPTOR.index -> builder.resolvedAttributes = deserializeResolvedAttributesDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
