// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.BatchDescribeModelPackageError
import aws.sdk.kotlin.services.sagemaker.model.BatchDescribeModelPackageResponse
import aws.sdk.kotlin.services.sagemaker.model.BatchDescribeModelPackageSummary
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class BatchDescribeModelPackageOperationDeserializer: HttpDeserialize<BatchDescribeModelPackageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchDescribeModelPackageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDescribeModelPackageError(context, call)
        }
        val builder = BatchDescribeModelPackageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDescribeModelPackageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchDescribeModelPackageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDescribeModelPackageOperationBody(builder: BatchDescribeModelPackageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BATCHDESCRIBEMODELPACKAGEERRORMAP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("BatchDescribeModelPackageErrorMap"))
    val MODELPACKAGESUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ModelPackageSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BATCHDESCRIBEMODELPACKAGEERRORMAP_DESCRIPTOR)
        field(MODELPACKAGESUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BATCHDESCRIBEMODELPACKAGEERRORMAP_DESCRIPTOR.index -> builder.batchDescribeModelPackageErrorMap =
                    deserializer.deserializeMap(BATCHDESCRIBEMODELPACKAGEERRORMAP_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, BatchDescribeModelPackageError>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBatchDescribeModelPackageErrorDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                MODELPACKAGESUMMARIES_DESCRIPTOR.index -> builder.modelPackageSummaries =
                    deserializer.deserializeMap(MODELPACKAGESUMMARIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, BatchDescribeModelPackageSummary>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBatchDescribeModelPackageSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
