// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Status and billing information about the warm pool.
 */
public class WarmPoolStatus private constructor(builder: Builder) {
    /**
     * The billable time in seconds used by the warm pool. Billable time refers to the absolute wall-clock time.
     *
     * Multiply `ResourceRetainedBillableTimeInSeconds` by the number of instances (`InstanceCount`) in your training cluster to get the total compute time SageMaker bills you if you run warm pool training. The formula is as follows: `ResourceRetainedBillableTimeInSeconds * InstanceCount`.
     */
    public val resourceRetainedBillableTimeInSeconds: kotlin.Int? = builder.resourceRetainedBillableTimeInSeconds
    /**
     * The name of the matching training job that reused the warm pool.
     */
    public val reusedByJob: kotlin.String? = builder.reusedByJob
    /**
     * The status of the warm pool.
     * + `InUse`: The warm pool is in use for the training job.
     * + `Available`: The warm pool is available to reuse for a matching training job.
     * + `Reused`: The warm pool moved to a matching training job for reuse.
     * + `Terminated`: The warm pool is no longer available. Warm pools are unavailable if they are terminated by a user, terminated for a patch update, or terminated for exceeding the specified `KeepAlivePeriodInSeconds`.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.WarmPoolResourceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WarmPoolStatus(")
        append("resourceRetainedBillableTimeInSeconds=$resourceRetainedBillableTimeInSeconds,")
        append("reusedByJob=$reusedByJob,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceRetainedBillableTimeInSeconds ?: 0
        result = 31 * result + (reusedByJob?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WarmPoolStatus

        if (resourceRetainedBillableTimeInSeconds != other.resourceRetainedBillableTimeInSeconds) return false
        if (reusedByJob != other.reusedByJob) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The billable time in seconds used by the warm pool. Billable time refers to the absolute wall-clock time.
         *
         * Multiply `ResourceRetainedBillableTimeInSeconds` by the number of instances (`InstanceCount`) in your training cluster to get the total compute time SageMaker bills you if you run warm pool training. The formula is as follows: `ResourceRetainedBillableTimeInSeconds * InstanceCount`.
         */
        public var resourceRetainedBillableTimeInSeconds: kotlin.Int? = null
        /**
         * The name of the matching training job that reused the warm pool.
         */
        public var reusedByJob: kotlin.String? = null
        /**
         * The status of the warm pool.
         * + `InUse`: The warm pool is in use for the training job.
         * + `Available`: The warm pool is available to reuse for a matching training job.
         * + `Reused`: The warm pool moved to a matching training job for reuse.
         * + `Terminated`: The warm pool is no longer available. Warm pools are unavailable if they are terminated by a user, terminated for a patch update, or terminated for exceeding the specified `KeepAlivePeriodInSeconds`.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.WarmPoolResourceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus) : this() {
            this.resourceRetainedBillableTimeInSeconds = x.resourceRetainedBillableTimeInSeconds
            this.reusedByJob = x.reusedByJob
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus = WarmPoolStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
