// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
 */
public class VpcConfig private constructor(builder: Builder) {
    /**
     * The VPC security group IDs, in the form `sg-xxxxxxxx`. Specify the security groups for the VPC that is specified in the `Subnets` field.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see [Supported Instance Types and Availability Zones](https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html).
     */
    public val subnets: List<String>? = builder.subnets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.VpcConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfig(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfig

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.VpcConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The VPC security group IDs, in the form `sg-xxxxxxxx`. Specify the security groups for the VPC that is specified in the `Subnets` field.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see [Supported Instance Types and Availability Zones](https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html).
         */
        public var subnets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.VpcConfig) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.VpcConfig = VpcConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
