// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Provided configuration information for the worker UI for a labeling job. Provide either `HumanTaskUiArn` or `UiTemplateS3Uri`.
 *
 * For named entity recognition, 3D point cloud and video frame labeling jobs, use `HumanTaskUiArn`.
 *
 * For all other Ground Truth built-in task types and custom task types, use `UiTemplateS3Uri` to specify the location of a worker task template in Amazon S3.
 */
public class UiConfig private constructor(builder: Builder) {
    /**
     * The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.
     *
     * Use this parameter when you are creating a labeling job for named entity recognition, 3D point cloud and video frame labeling jobs. Use your labeling job task type to select one of the following ARNs and use it with this parameter when you create a labeling job. Replace `aws-region` with the Amazon Web Services Region you are creating your labeling job in. For example, replace `aws-region` with `us-west-1` if you create a labeling job in US West (N. California).
     *
     * **Named Entity Recognition**
     *
     * Use the following `HumanTaskUiArn` for named entity recognition labeling jobs:
     *
     * `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/NamedEntityRecognition`
     *
     * **3D Point Cloud HumanTaskUiArns**
     *
     * Use this `HumanTaskUiArn` for 3D point cloud object detection and 3D point cloud object detection adjustment labeling jobs.
     * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection`
     *
     *  Use this `HumanTaskUiArn` for 3D point cloud object tracking and 3D point cloud object tracking adjustment labeling jobs.
     * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking`
     *
     *  Use this `HumanTaskUiArn` for 3D point cloud semantic segmentation and 3D point cloud semantic segmentation adjustment labeling jobs.
     * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation`
     *
     * **Video Frame HumanTaskUiArns**
     *
     * Use this `HumanTaskUiArn` for video frame object detection and video frame object detection adjustment labeling jobs.
     * + `arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection`
     *
     *  Use this `HumanTaskUiArn` for video frame object tracking and video frame object tracking adjustment labeling jobs.
     * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking`
     */
    public val humanTaskUiArn: kotlin.String? = builder.humanTaskUiArn
    /**
     * The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to render the worker UI and tools for labeling job tasks. For more information about the contents of a UI template, see [ Creating Your Custom Labeling Task Template](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html).
     */
    public val uiTemplateS3Uri: kotlin.String? = builder.uiTemplateS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UiConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UiConfig(")
        append("humanTaskUiArn=$humanTaskUiArn,")
        append("uiTemplateS3Uri=$uiTemplateS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = humanTaskUiArn?.hashCode() ?: 0
        result = 31 * result + (uiTemplateS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UiConfig

        if (humanTaskUiArn != other.humanTaskUiArn) return false
        if (uiTemplateS3Uri != other.uiTemplateS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UiConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.
         *
         * Use this parameter when you are creating a labeling job for named entity recognition, 3D point cloud and video frame labeling jobs. Use your labeling job task type to select one of the following ARNs and use it with this parameter when you create a labeling job. Replace `aws-region` with the Amazon Web Services Region you are creating your labeling job in. For example, replace `aws-region` with `us-west-1` if you create a labeling job in US West (N. California).
         *
         * **Named Entity Recognition**
         *
         * Use the following `HumanTaskUiArn` for named entity recognition labeling jobs:
         *
         * `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/NamedEntityRecognition`
         *
         * **3D Point Cloud HumanTaskUiArns**
         *
         * Use this `HumanTaskUiArn` for 3D point cloud object detection and 3D point cloud object detection adjustment labeling jobs.
         * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection`
         *
         *  Use this `HumanTaskUiArn` for 3D point cloud object tracking and 3D point cloud object tracking adjustment labeling jobs.
         * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking`
         *
         *  Use this `HumanTaskUiArn` for 3D point cloud semantic segmentation and 3D point cloud semantic segmentation adjustment labeling jobs.
         * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation`
         *
         * **Video Frame HumanTaskUiArns**
         *
         * Use this `HumanTaskUiArn` for video frame object detection and video frame object detection adjustment labeling jobs.
         * + `arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection`
         *
         *  Use this `HumanTaskUiArn` for video frame object tracking and video frame object tracking adjustment labeling jobs.
         * + `arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking`
         */
        public var humanTaskUiArn: kotlin.String? = null
        /**
         * The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to render the worker UI and tools for labeling job tasks. For more information about the contents of a UI template, see [ Creating Your Custom Labeling Task Template](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html).
         */
        public var uiTemplateS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UiConfig) : this() {
            this.humanTaskUiArn = x.humanTaskUiArn
            this.uiTemplateS3Uri = x.uiTemplateS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UiConfig = UiConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
