// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties of a trial as returned by the [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API.
 */
public class Trial private constructor(builder: Builder) {
    /**
     * Who created the trial.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * When the trial was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the trial as displayed. If `DisplayName` isn't specified, `TrialName` is displayed.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the experiment the trial is part of.
     */
    public val experimentName: kotlin.String? = builder.experimentName
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * Who last modified the trial.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    public val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * The source of the trial.
     */
    public val source: aws.sdk.kotlin.services.sagemaker.model.TrialSource? = builder.source
    /**
     * The list of tags that are associated with the trial. You can use [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API to search on the tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the trial.
     */
    public val trialArn: kotlin.String? = builder.trialArn
    /**
     * A list of the components associated with the trial. For each component, a summary of the component's properties is included.
     */
    public val trialComponentSummaries: List<TrialComponentSimpleSummary>? = builder.trialComponentSummaries
    /**
     * The name of the trial.
     */
    public val trialName: kotlin.String? = builder.trialName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Trial = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Trial(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("displayName=$displayName,")
        append("experimentName=$experimentName,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("metadataProperties=$metadataProperties,")
        append("source=$source,")
        append("tags=$tags,")
        append("trialArn=$trialArn,")
        append("trialComponentSummaries=$trialComponentSummaries,")
        append("trialName=$trialName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (experimentName?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trialArn?.hashCode() ?: 0)
        result = 31 * result + (trialComponentSummaries?.hashCode() ?: 0)
        result = 31 * result + (trialName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Trial

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (displayName != other.displayName) return false
        if (experimentName != other.experimentName) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (metadataProperties != other.metadataProperties) return false
        if (source != other.source) return false
        if (tags != other.tags) return false
        if (trialArn != other.trialArn) return false
        if (trialComponentSummaries != other.trialComponentSummaries) return false
        if (trialName != other.trialName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Trial = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Who created the trial.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the trial was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the trial as displayed. If `DisplayName` isn't specified, `TrialName` is displayed.
         */
        public var displayName: kotlin.String? = null
        /**
         * The name of the experiment the trial is part of.
         */
        public var experimentName: kotlin.String? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * Who last modified the trial.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        public var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * The source of the trial.
         */
        public var source: aws.sdk.kotlin.services.sagemaker.model.TrialSource? = null
        /**
         * The list of tags that are associated with the trial. You can use [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API to search on the tags.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the trial.
         */
        public var trialArn: kotlin.String? = null
        /**
         * A list of the components associated with the trial. For each component, a summary of the component's properties is included.
         */
        public var trialComponentSummaries: List<TrialComponentSimpleSummary>? = null
        /**
         * The name of the trial.
         */
        public var trialName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Trial) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.displayName = x.displayName
            this.experimentName = x.experimentName
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.metadataProperties = x.metadataProperties
            this.source = x.source
            this.tags = x.tags
            this.trialArn = x.trialArn
            this.trialComponentSummaries = x.trialComponentSummaries
            this.trialName = x.trialName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Trial = Trial(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        public fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.sagemaker.model.TrialSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.sagemaker.model.TrialSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
