// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The collection of settings used by an AutoML job V2 for the time-series forecasting problem type.
 */
public class TimeSeriesForecastingJobConfig private constructor(builder: Builder) {
    /**
     * How long a job is allowed to run, or how many candidates a job is allowed to generate.
     */
    public val completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = builder.completionCriteria
    /**
     * A URL to the Amazon S3 data source containing additional selected features that complement the target, itemID, timestamp, and grouped columns set in `TimeSeriesConfig`. When not provided, the AutoML job V2 includes all the columns from the original dataset that are not already declared in `TimeSeriesConfig`. If provided, the AutoML job V2 only considers these additional columns as a complement to the ones declared in `TimeSeriesConfig`.
     *
     * You can input `FeatureAttributeNames` (optional) in JSON format as shown below:
     *
     * `{ "FeatureAttributeNames":["col1", "col2", ...] }`.
     *
     * You can also specify the data type of the feature (optional) in the format shown below:
     *
     * `{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }`
     *
     * Autopilot supports the following data types: `numeric`, `categorical`, `text`, and `datetime`.
     *
     * These column keys must not include any column set in `TimeSeriesConfig`.
     */
    public val featureSpecificationS3Uri: kotlin.String? = builder.featureSpecificationS3Uri
    /**
     * The frequency of predictions in a forecast.
     *
     * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, `1D` indicates every day and `15min` indicates every 15 minutes. The value of a frequency must not overlap with the next larger frequency. For example, you must use a frequency of `1H` instead of `60min`.
     *
     * The valid values for each frequency are the following:
     * + Minute - 1-59
     * + Hour - 1-23
     * + Day - 1-6
     * + Week - 1-4
     * + Month - 1-11
     * + Year - 1
     */
    public val forecastFrequency: kotlin.String? = builder.forecastFrequency
    /**
     * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length. The maximum forecast horizon is the lesser of 500 time-steps or 1/4 of the time-steps in the dataset.
     */
    public val forecastHorizon: kotlin.Int? = builder.forecastHorizon
    /**
     * The quantiles used to train the model for forecasts at a specified quantile. You can specify quantiles from `0.01` (p1) to `0.99` (p99), by increments of 0.01 or higher. Up to five forecast quantiles can be specified. When `ForecastQuantiles` is not provided, the AutoML job uses the quantiles p10, p50, and p90 as default.
     */
    public val forecastQuantiles: List<String>? = builder.forecastQuantiles
    /**
     * The collection of holiday featurization attributes used to incorporate national holiday information into your forecasting model.
     */
    public val holidayConfig: List<HolidayConfigAttributes>? = builder.holidayConfig
    /**
     * The collection of components that defines the time-series.
     */
    public val timeSeriesConfig: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesConfig? = builder.timeSeriesConfig
    /**
     * The transformations modifying specific attributes of the time-series, such as filling strategies for missing values.
     */
    public val transformations: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations? = builder.transformations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeSeriesForecastingJobConfig(")
        append("completionCriteria=$completionCriteria,")
        append("featureSpecificationS3Uri=$featureSpecificationS3Uri,")
        append("forecastFrequency=$forecastFrequency,")
        append("forecastHorizon=$forecastHorizon,")
        append("forecastQuantiles=$forecastQuantiles,")
        append("holidayConfig=$holidayConfig,")
        append("timeSeriesConfig=$timeSeriesConfig,")
        append("transformations=$transformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionCriteria?.hashCode() ?: 0
        result = 31 * result + (featureSpecificationS3Uri?.hashCode() ?: 0)
        result = 31 * result + (forecastFrequency?.hashCode() ?: 0)
        result = 31 * result + (forecastHorizon ?: 0)
        result = 31 * result + (forecastQuantiles?.hashCode() ?: 0)
        result = 31 * result + (holidayConfig?.hashCode() ?: 0)
        result = 31 * result + (timeSeriesConfig?.hashCode() ?: 0)
        result = 31 * result + (transformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeSeriesForecastingJobConfig

        if (completionCriteria != other.completionCriteria) return false
        if (featureSpecificationS3Uri != other.featureSpecificationS3Uri) return false
        if (forecastFrequency != other.forecastFrequency) return false
        if (forecastHorizon != other.forecastHorizon) return false
        if (forecastQuantiles != other.forecastQuantiles) return false
        if (holidayConfig != other.holidayConfig) return false
        if (timeSeriesConfig != other.timeSeriesConfig) return false
        if (transformations != other.transformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingJobConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * How long a job is allowed to run, or how many candidates a job is allowed to generate.
         */
        public var completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = null
        /**
         * A URL to the Amazon S3 data source containing additional selected features that complement the target, itemID, timestamp, and grouped columns set in `TimeSeriesConfig`. When not provided, the AutoML job V2 includes all the columns from the original dataset that are not already declared in `TimeSeriesConfig`. If provided, the AutoML job V2 only considers these additional columns as a complement to the ones declared in `TimeSeriesConfig`.
         *
         * You can input `FeatureAttributeNames` (optional) in JSON format as shown below:
         *
         * `{ "FeatureAttributeNames":["col1", "col2", ...] }`.
         *
         * You can also specify the data type of the feature (optional) in the format shown below:
         *
         * `{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }`
         *
         * Autopilot supports the following data types: `numeric`, `categorical`, `text`, and `datetime`.
         *
         * These column keys must not include any column set in `TimeSeriesConfig`.
         */
        public var featureSpecificationS3Uri: kotlin.String? = null
        /**
         * The frequency of predictions in a forecast.
         *
         * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, `1D` indicates every day and `15min` indicates every 15 minutes. The value of a frequency must not overlap with the next larger frequency. For example, you must use a frequency of `1H` instead of `60min`.
         *
         * The valid values for each frequency are the following:
         * + Minute - 1-59
         * + Hour - 1-23
         * + Day - 1-6
         * + Week - 1-4
         * + Month - 1-11
         * + Year - 1
         */
        public var forecastFrequency: kotlin.String? = null
        /**
         * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length. The maximum forecast horizon is the lesser of 500 time-steps or 1/4 of the time-steps in the dataset.
         */
        public var forecastHorizon: kotlin.Int? = null
        /**
         * The quantiles used to train the model for forecasts at a specified quantile. You can specify quantiles from `0.01` (p1) to `0.99` (p99), by increments of 0.01 or higher. Up to five forecast quantiles can be specified. When `ForecastQuantiles` is not provided, the AutoML job uses the quantiles p10, p50, and p90 as default.
         */
        public var forecastQuantiles: List<String>? = null
        /**
         * The collection of holiday featurization attributes used to incorporate national holiday information into your forecasting model.
         */
        public var holidayConfig: List<HolidayConfigAttributes>? = null
        /**
         * The collection of components that defines the time-series.
         */
        public var timeSeriesConfig: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesConfig? = null
        /**
         * The transformations modifying specific attributes of the time-series, such as filling strategies for missing values.
         */
        public var transformations: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingJobConfig) : this() {
            this.completionCriteria = x.completionCriteria
            this.featureSpecificationS3Uri = x.featureSpecificationS3Uri
            this.forecastFrequency = x.forecastFrequency
            this.forecastHorizon = x.forecastHorizon
            this.forecastQuantiles = x.forecastQuantiles
            this.holidayConfig = x.holidayConfig
            this.timeSeriesConfig = x.timeSeriesConfig
            this.transformations = x.transformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingJobConfig = TimeSeriesForecastingJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria] inside the given [block]
         */
        public fun completionCriteria(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.Builder.() -> kotlin.Unit) {
            this.completionCriteria = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TimeSeriesConfig] inside the given [block]
         */
        public fun timeSeriesConfig(block: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesConfig.Builder.() -> kotlin.Unit) {
            this.timeSeriesConfig = aws.sdk.kotlin.services.sagemaker.model.TimeSeriesConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations] inside the given [block]
         */
        public fun transformations(block: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations.Builder.() -> kotlin.Unit) {
            this.transformations = aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
